/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeSandy
extends AbstractCaveType {
    private final IBlockState sand;
    private final IBlockState sandstone;

    public CaveTypeSandy(String name, int ceilingAddonPercentChance, int floorAddonPercentChance, boolean redSand) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
        this.sand = redSand ? Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND) : Blocks.field_150354_m.func_176223_P();
        this.sandstone = redSand ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 5.0, 0.2f);
        if (noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, this.sandstone);
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 5.0, 0.2f);
        if (noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, this.sandstone);
        } else if (noise < (double)(depth * 6.0f)) {
            gen.replaceBlock(pos, this.sand);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.genStalactite(pos, depth, false);
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 5.0, 0.2f);
        if (noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, this.sand);
        }
        gen.genStalagmite(pos, depth, false);
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        double noise = this.getNoise(pos, 5.0, 0.2f);
        if (noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, this.sandstone);
        } else if (noise < (double)(depth * 6.0f)) {
            gen.replaceBlock(pos, this.sand);
        }
    }
}

