/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.config.OverworldGenConfig;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeRocky
extends AbstractCaveType {
    public CaveTypeRocky(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextBoolean() && this.getNoise(pos, 2.0, 0.2f) < 1.0) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextBoolean() && this.getNoise(pos, 5.0, 1.0f) < 1.0) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (!(random.nextFloat() < depth) || !gen.genStalactite(pos, depth, false)) {
            gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (!(random.nextFloat() < depth) || !gen.genStalagmite(pos, depth, false)) {
            gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (random.nextBoolean() && this.getNoise(pos, 5.0, 1.0f) < 1.5) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void setTopBlock(CaveBiomeGenMethods gen, Random random, SurfacePos pos) {
        if (this.getNoise(pos, 0.05, 1.0f) < OverworldGenConfig.mountainFracChunkPercent && this.getNoise(pos, 1.0, 1.0f) < OverworldGenConfig.mountainFracFreq) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }
}

