/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.config.OverworldGenConfig;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeMossy
extends AbstractCaveType {
    private final IBlockState dirt;

    public CaveTypeMossy(String name, int ceilingAddonPercentChance, int floorAddonPercentChance, IBlockState block) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
        this.dirt = block;
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos, 5.0, 0.2f) < (double)(depth * 2.0f)) {
            gen.replaceBlock(pos, this.dirt);
        }
        if (this.getNoise(pos, 5.0, 2.0f) < (double)depth) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.genStalactite(pos, depth, false);
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextBoolean()) {
            gen.genStalagmite(pos, depth, false);
        } else {
            gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
            gen.transformBlock(pos.func_177984_a(), BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (this.getNoise(pos, 5.0, 0.33f) > (double)(height / 2)) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
            if (this.getNoise(pos, 2.0, 2.0f) < (double)depth) {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        } else if (this.getNoise(pos, 5.0, 1.0f) < (double)depth) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void setTopBlock(CaveBiomeGenMethods gen, Random random, SurfacePos pos) {
        if (this.getNoise(pos, 0.05, 1.0f) < OverworldGenConfig.forestMossChunkPercent && this.getNoise(pos, 1.0, 1.0f) < OverworldGenConfig.ForestMossFreq) {
            if (gen.getBlockState(pos).func_177230_c().hashCode() == Blocks.field_150349_c.hashCode()) {
                gen.replaceBlock(pos, WTFBlocks.mossyDirt.func_176223_P());
            }
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }
}

