/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeJungleVolcano
extends AbstractCaveType {
    public CaveTypeJungleVolcano(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 6.0, 0.4f);
        if (noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, Blocks.field_150349_c.func_176223_P());
        } else if (noise > (double)(depth * 6.0f) && noise > 4.0) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
            if (noise > (double)(depth * 7.0f) && noise > 5.0) {
                gen.setLavaPatch(pos);
            }
        } else if (noise < 3.0) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextFloat() < depth && !gen.isChunkEdge(pos) && gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE)) {
            int loop;
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177974_f().func_177979_c(loop), EnumFacing.WEST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177976_e().func_177979_c(loop), EnumFacing.EAST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177978_c().func_177979_c(loop), EnumFacing.SOUTH);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177968_d().func_177979_c(loop), EnumFacing.NORTH);
            }
        } else if (!gen.genStalagmite(pos, depth, false)) {
            gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos.func_177977_b(), 6.0, 0.2f);
        if (noise < (double)(depth * 4.0f)) {
            gen.replaceBlock(pos, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN));
        } else if (random.nextFloat() > depth && !gen.genStalagmite(pos, depth, false)) {
            gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        double mossNoise = this.getNoise(pos, 5.0, 2.0f);
        if (mossNoise < (double)(2.0f * depth) && random.nextBoolean()) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        } else if ((double)random.nextFloat() < 0.1) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
        }
    }

    @Override
    public void generateAdjacentWall(CaveBiomeGenMethods gen, Random random, AdjPos pos, float depth, int height) {
        if (this.getNoise(pos, 5.0, 1.0f) < (double)depth * 1.5) {
            gen.GenVines(pos, pos.getFace(random));
        }
    }
}

