/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeIceRocky
extends AbstractCaveType {
    public CaveTypeIceRocky(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 5.0, 1.0f);
        if (noise > (double)(depth * 5.0f)) {
            gen.replaceBlock(pos, Blocks.field_150403_cj.func_176223_P());
        } else if (random.nextBoolean() && noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, Blocks.field_150347_e.func_176223_P());
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 5.0, 1.0f);
        if (noise > (double)(depth * 5.0f)) {
            gen.replaceBlock(pos, Blocks.field_150403_cj.func_176223_P());
        } else if (random.nextBoolean() && noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, Blocks.field_150347_e.func_176223_P());
        }
        gen.setIcePatch(pos);
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (!gen.genStalactite(pos, depth, true)) {
            gen.replaceBlock(pos, Blocks.field_150403_cj.func_176223_P());
        }
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (!gen.genStalagmite(pos, depth, true)) {
            gen.replaceBlock(pos, Blocks.field_150403_cj.func_176223_P());
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        double noise = this.getNoise(pos, 5.0, 1.0f);
        if (noise > (double)(depth * 5.0f)) {
            gen.replaceBlock(pos, Blocks.field_150403_cj.func_176223_P());
        } else if (random.nextBoolean() && noise < (double)(depth * 3.0f)) {
            gen.replaceBlock(pos, Blocks.field_150347_e.func_176223_P());
        }
    }
}

