/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeFungal
extends AbstractCaveType {
    public CaveTypeFungal(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos, 2.0, 0.5f) > 1.0) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos, 2.0, 0.1f) > 1.0) {
            gen.replaceBlock(pos, Blocks.field_150391_bh.func_176223_P());
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos.func_177984_a(), 2.0, 0.5f) > 1.0) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
        } else {
            gen.genStalactite(pos, depth, false);
        }
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos.func_177977_b(), 2.0, 0.1f) > 1.0) {
            if (pos.func_177956_o() < 53) {
                gen.replaceBlock(pos, Blocks.field_150338_P.func_176223_P());
            } else {
                gen.replaceBlock(pos, Blocks.field_150337_Q.func_176223_P());
            }
        } else {
            gen.genStalagmite(pos, depth, false);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (this.getNoise(pos, 2.0, 0.5f) > 1.0) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
        }
    }
}

