/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.BiomeDictionary;
import wtf.blocks.BlockIcicle;
import wtf.blocks.BlockRoots;
import wtf.blocks.BlockSpeleothem;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkDividedHashMap;
import wtf.utilities.wrappers.StateAndModifier;

public class CaveBiomeGenMethods {
    public final Chunk chunk;
    public final ChunkDividedHashMap blocksToSet;
    public final Random random;
    int darkStateHash = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK).hashCode();
    public static int airHash = Blocks.field_150350_a.hashCode();

    public CaveBiomeGenMethods(World world, ChunkCoords coords, Random random) {
        this.chunk = coords.getChunk(world);
        this.blocksToSet = new ChunkDividedHashMap(this.chunk.func_177412_p(), coords);
        this.random = random;
    }

    public IBlockState getBlockState(BlockPos pos) {
        ExtendedBlockStorage extendedblockstorage;
        IBlockState returnable = this.blocksToSet.get(pos);
        if (returnable != null) {
            return returnable;
        }
        returnable = this.chunk.func_177435_g(pos);
        int y = pos.func_177956_o() >> 4;
        if (y < this.chunk.func_76587_i().length && (extendedblockstorage = this.chunk.func_76587_i()[y]) != Chunk.field_186036_a && (returnable = extendedblockstorage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF)) == null) {
            returnable = Blocks.field_150350_a.func_176223_P();
        }
        return returnable;
    }

    public boolean transformBlock(BlockPos pos, BlockSets.Modifier modifier) {
        IBlockState oldBlock = this.getBlockState(pos);
        IBlockState blockToSet = BlockSets.blockTransformer.get(new StateAndModifier(oldBlock, modifier));
        if (blockToSet != null) {
            this.blocksToSet.put(pos, blockToSet);
            return true;
        }
        return false;
    }

    public boolean replaceBlock(BlockPos pos, IBlockState state) {
        if (BlockSets.ReplaceHashset.contains(this.getBlockState(pos).func_177230_c())) {
            this.blocksToSet.put(pos, state);
            return true;
        }
        return false;
    }

    public boolean setFloorAddon(BlockPos pos, BlockSets.Modifier modifier) {
        IBlockState oldState = this.getBlockState(pos.func_177977_b());
        IBlockState newState = BlockSets.blockTransformer.get(new StateAndModifier(oldState, modifier));
        if (newState != null) {
            this.blocksToSet.put(pos, newState);
            return true;
        }
        return false;
    }

    public boolean setCeilingAddon(BlockPos pos, BlockSets.Modifier modifier) {
        IBlockState oldState = this.getBlockState(pos.func_177984_a());
        IBlockState newState = BlockSets.blockTransformer.get(new StateAndModifier(oldState, modifier));
        if (newState != null) {
            this.blocksToSet.put(pos, newState);
            return true;
        }
        return false;
    }

    public void setIcePatch(BlockPos pos) {
        if (this.getBlockState(pos.func_177984_a()).func_177230_c().hashCode() == airHash) {
            this.blocksToSet.put(pos.func_177984_a(), WTFBlocks.icePatch.func_176223_P());
        }
    }

    public void setWaterPatch(BlockPos pos) {
        if (this.getBlockState(pos.func_177984_a()).func_177230_c().hashCode() == airHash) {
            this.blocksToSet.put(pos.func_177984_a(), WTFBlocks.waterPatch.func_176223_P());
        }
    }

    public void setLavaPatch(BlockPos pos) {
        if (this.getBlockState(pos.func_177984_a()).func_177230_c().hashCode() == airHash) {
            this.blocksToSet.put(pos.func_177984_a(), WTFBlocks.lavaPatch.func_176223_P());
        }
    }

    public void genFloatingStone(World world, BlockPos pos, Block block) {
        this.blocksToSet.put(pos, block.func_176223_P());
    }

    public boolean genStalagmite(BlockPos pos, float depth, boolean frozen) {
        if (this.chunk.func_177435_g(pos).func_177230_c().hashCode() != airHash) {
            return false;
        }
        IBlockState oldState = this.getBlockState(pos.func_177977_b());
        BlockSpeleothem block = WTFBlocks.speleothemMap.get(oldState);
        if (block == null) {
            return false;
        }
        if (frozen) {
            block = block.frozen;
        }
        int size = MathHelper.func_76123_f((float)(this.random.nextFloat() + 1.0f - depth));
        for (int i = 0; i < size; ++i) {
            int up1Hash = this.getBlockState(pos.func_177981_b(i)).func_177230_c().hashCode();
            if (i == 0) {
                if (size > 1 && up1Hash == airHash) {
                    this.blocksToSet.put(pos.func_177981_b(i), block.getBlockState(BlockSpeleothem.SpType.stalagmite_base));
                    continue;
                }
                this.blocksToSet.put(pos.func_177981_b(i), block.getBlockState(BlockSpeleothem.SpType.stalagmite_small));
                break;
            }
            if (i < size - 1 && up1Hash == Blocks.field_150350_a.hashCode()) {
                this.blocksToSet.put(pos.func_177981_b(i), block.getBlockState(BlockSpeleothem.SpType.column));
                continue;
            }
            if (up1Hash == block.parentBackground.func_177230_c().hashCode()) {
                this.blocksToSet.put(pos.func_177981_b(i), block.getBlockState(BlockSpeleothem.SpType.stalactite_base));
                break;
            }
            this.blocksToSet.put(pos.func_177981_b(i), block.getBlockState(BlockSpeleothem.SpType.stalagmite_tip));
            break;
        }
        return true;
    }

    public boolean genStalactite(BlockPos pos, float depth, boolean frozen) {
        if (this.chunk.func_177435_g(pos).func_177230_c().hashCode() != airHash) {
            return false;
        }
        IBlockState oldState = this.getBlockState(pos.func_177984_a());
        BlockSpeleothem block = WTFBlocks.speleothemMap.get(oldState);
        if (block == null) {
            if (oldState.func_177230_c().hashCode() == Blocks.field_150346_d.hashCode() && (double)depth > 0.8) {
                this.genRoot(pos);
            }
            return false;
        }
        if (frozen) {
            block = block.frozen;
        }
        int size = MathHelper.func_76123_f((float)(this.random.nextFloat() + 1.0f - depth));
        for (int i = 0; i < size; ++i) {
            int down1Hash = this.getBlockState(pos.func_177979_c(i)).func_177230_c().hashCode();
            if (i == 0) {
                if (size > 1 && down1Hash == airHash) {
                    this.blocksToSet.put(pos.func_177979_c(i), block.getBlockState(BlockSpeleothem.SpType.stalactite_base));
                    continue;
                }
                this.blocksToSet.put(pos.func_177979_c(i), block.getBlockState(BlockSpeleothem.SpType.stalactite_small));
                break;
            }
            if (i < size - 1 && down1Hash == airHash) {
                this.blocksToSet.put(pos.func_177979_c(i), block.getBlockState(BlockSpeleothem.SpType.column));
                continue;
            }
            if (down1Hash == block.parentBackground.hashCode()) {
                this.blocksToSet.put(pos.func_177979_c(i), block.getBlockState(BlockSpeleothem.SpType.stalagmite_base));
                break;
            }
            this.blocksToSet.put(pos.func_177979_c(i), block.getBlockState(BlockSpeleothem.SpType.stalactite_tip));
            break;
        }
        return true;
    }

    public void genIcicle(BlockPos pos) {
        if (this.random.nextBoolean() && this.getBlockState(pos.func_177977_b()).hashCode() == airHash) {
            this.blocksToSet.put(pos, WTFBlocks.icicle.getBlockState(BlockIcicle.IcicleType.icicle_base));
            this.blocksToSet.put(pos.func_177977_b(), WTFBlocks.icicle.getBlockState(BlockIcicle.IcicleType.icicle_tip));
        } else {
            this.blocksToSet.put(pos, WTFBlocks.icicle.getBlockState(BlockIcicle.IcicleType.icicle_small));
        }
    }

    public void GenVines(BlockPos pos, EnumFacing facing) {
        IBlockState block = null;
        switch (facing) {
            case EAST: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true));
                break;
            }
            case NORTH: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true));
                break;
            }
            case SOUTH: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true));
                break;
            }
            case WEST: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true));
            }
        }
        this.blocksToSet.put(pos, block);
    }

    public void genRoot(BlockPos pos) {
        Biome biome = this.chunk.func_177411_a(pos, this.chunk.func_177412_p().func_72959_q());
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            this.blocksToSet.put(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.spruce)));
        } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            this.blocksToSet.put(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.acacia)));
        } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            this.blocksToSet.put(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.jungle)));
        } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            this.blocksToSet.put(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.big_oak)));
        } else if (biome.func_185359_l().contains("irch")) {
            this.blocksToSet.put(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.birch)));
        } else {
            this.blocksToSet.put(pos, WTFBlocks.roots.func_176223_P());
        }
    }

    public void spawnVanillaSpawner(BlockPos pos, String entityName, int count) {
        this.chunk.func_177412_p().func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)this.chunk.func_177412_p().func_175625_s(pos);
        if (spawner != null) {
            spawner.func_145881_a().func_98272_a(entityName);
            NBTTagCompound nbt = new NBTTagCompound();
            spawner.func_189515_b(nbt);
            nbt.func_74777_a("spawnCount", (short)count);
            nbt.func_74777_a("MinSpawnDelay", (short)(1000 / count));
            spawner.func_145839_a(nbt);
        } else {
            System.out.println("VanillaGen: SpawnVanillaSpawner- failed to set spawner entity");
        }
    }

    public boolean isChunkEdge(BlockPos pos) {
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        return x == 0 || x == 15 || z == 0 || z == 15;
    }
}

