/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.api.PopulationGenerator;
import wtf.config.CoreConfig;
import wtf.config.OverworldGenConfig;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;
import wtf.worldgen.caves.CaveProfile;
import wtf.worldgen.caves.CaveTypeRegister;

public class PopulationDecorator
extends PopulationGenerator {
    @Override
    public void generate(World world, ChunkCoords coords, Random random, ChunkScan chunkscan) throws Exception {
        CaveBiomeGenMethods gen = new CaveBiomeGenMethods(world, coords, random);
        if (CoreConfig.caveGeneration) {
            PopulationDecorator.genCaves(world, gen, coords, random, chunkscan);
        }
        CaveProfile profile = CaveTypeRegister.getCaveProfile(world.getBiomeForCoordsBody((BlockPos)chunkscan.surface[8][8]));
        if (OverworldGenConfig.modifySurface) {
            PopulationDecorator.genSurfaceBlocks(profile, gen, random, chunkscan);
        }
        gen.blocksToSet.setBlockSet();
    }

    public static void genCaves(World world, CaveBiomeGenMethods gen, ChunkCoords coords, Random random, ChunkScan chunkscan) {
        for (CaveListWrapper cave : chunkscan.caveset) {
            CaveProfile profile = CaveTypeRegister.getCaveProfile(cave.getBiome(world));
            double depth = (double)((float)cave.getAvgFloor()) / chunkscan.surfaceAvg;
            AbstractCaveType cavetype = profile.getCave(cave.cave.get(0), (int)chunkscan.surfaceAvg);
            for (BlockPos pos : cave.wall) {
                int x = pos.func_177958_n() >> 4;
                int z = pos.func_177958_n() >> 4;
                if (x != coords.getChunkX() || z != coords.getChunkX()) {
                    cavetype.generateWall(gen, random, pos, (float)pos.func_177956_o() / (float)chunkscan.surfaceAvg, pos.func_177956_o() - (int)cave.getAvgFloor());
                    continue;
                }
                cavetype.generateWall(gen, random, pos, (float)pos.func_177956_o() / (float)chunkscan.surfaceAvg, pos.func_177956_o() - (int)cave.getAvgFloor());
            }
            for (AdjPos adj : cave.adjacentWall) {
                cavetype.generateAdjacentWall(gen, random, adj, (float)adj.func_177956_o() / (float)chunkscan.surfaceAvg, adj.func_177956_o() - (int)cave.getAvgFloor());
            }
            for (CavePosition position : cave.cave) {
                if (position.alreadyGenerated) continue;
                cavetype.generateFloor(gen, random, position.getFloorPos(), (float)depth);
                cavetype.generateCeiling(gen, random, position.getCeilingPos(), (float)depth);
                if ((double)random.nextInt(100) < (double)cavetype.ceilingaddonchance + (1.0 - depth) * 5.0) {
                    cavetype.generateCeilingAddons(gen, random, position.getCeilingPos().func_177977_b(), (float)depth);
                }
                if ((double)random.nextInt(100) < (double)cavetype.flooraddonchance + (1.0 - depth) * 5.0) {
                    cavetype.generateFloorAddons(gen, random, position.getFloorPos().func_177984_a(), (float)depth);
                }
                position.alreadyGenerated = true;
            }
        }
    }

    public static void genSurfaceBlocks(CaveProfile profile, CaveBiomeGenMethods gen, Random random, ChunkScan scan) {
        SurfacePos[][] surfacePosArray = scan.surface;
        int n = surfacePosArray.length;
        for (int i = 0; i < n; ++i) {
            SurfacePos[] arrayZ;
            for (SurfacePos pos : arrayZ = surfacePosArray[i]) {
                profile.caveShallow.setTopBlock(gen, random, pos);
            }
        }
    }
}

