/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenerator;
import wtf.api.PopulationGenerator;
import wtf.config.CoreConfig;
import wtf.config.OverworldGenConfig;
import wtf.utilities.Simplex;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.subbiomes.SubBiome;
import wtf.worldgen.trees.GenTree;
import wtf.worldgen.trees.TreePos;
import wtf.worldgen.trees.TreeTypeGetter;
import wtf.worldgen.trees.TreeVars;
import wtf.worldgen.trees.types.RootsOnly;

public class OverworldGen
extends PopulationGenerator {
    Simplex simplex = null;
    Simplex simplex2 = null;
    World prevWorld = null;
    public static boolean RTG = false;
    public static HashMap<Byte, SubBiome> subBiomeRegistry = new HashMap();

    @Override
    public void generate(World world, ChunkCoords chunkcoords, Random random, ChunkScan chunkscan) throws Exception {
        if (this.simplex == null || world.hashCode() != this.prevWorld.hashCode()) {
            this.simplex = new Simplex((int)world.func_72905_C());
            this.simplex2 = new Simplex((int)world.func_72905_C() * 2);
            this.prevWorld = world;
        }
        byte[] newBiomes = chunkcoords.getChunk(world).func_76605_m();
        for (int xloop = 0; xloop < 16; ++xloop) {
            for (int zloop = 0; zloop < 16; ++zloop) {
                double z;
                double x;
                int loop = xloop + zloop * 16;
                SubBiome sub = subBiomeRegistry.get(newBiomes[loop]);
                if (sub == null || !(this.simplex.noise(x = (double)(xloop + chunkcoords.getWorldX()) / sub.scale(), z = (double)(zloop + chunkcoords.getWorldZ()) / sub.scale()) * 0.5 + 0.5 < sub.freq())) continue;
                newBiomes[loop] = sub.getID();
                sub.resetTopBlock(world, chunkscan.surface[xloop][zloop]);
            }
        }
        if (CoreConfig.enableOverworldGeneration && OverworldGenConfig.genTrees) {
            this.genTrees(world, chunkcoords, random, chunkscan);
        }
    }

    public void genTrees(World world, ChunkCoords chunkcoords, Random random, ChunkScan chunkscan) throws Exception {
        SurfacePos pos;
        ArrayList<WorldGenerator> shrubgenerators = new ArrayList<WorldGenerator>();
        for (int loopx = 0; loopx < 4; ++loopx) {
            for (int loopz = 0; loopz < 4; ++loopz) {
                pos = chunkscan.surface[4 * loopx + random.nextInt(4)][4 * loopz + random.nextInt(4)];
                for (int loop = 0; loop < 3 && pos.generated; ++loop) {
                    pos = chunkscan.surface[4 * loopx + random.nextInt(4)][4 * loopz + random.nextInt(4)];
                }
                Biome biome = world.func_180494_b((BlockPos)pos);
                double numTrees = biome.field_76760_I.field_76832_z > -1 ? (double)biome.field_76760_I.field_76832_z : 16.0;
                double genChance = 16.0 * numTrees / 240.0;
                if (!(genChance > 0.0) || pos.generated || !((double)random.nextFloat() < genChance)) continue;
                boolean doReplace = this.customTree(random, pos);
                WorldGenerator oldTree = null;
                for (int loop = 0; loop < 4 && oldTree == null; ++loop) {
                    WorldGenerator tempTree = this.getTree(random, biome, chunkscan, doReplace);
                    if (tempTree instanceof WorldGenShrub) {
                        shrubgenerators.add(tempTree);
                        continue;
                    }
                    oldTree = tempTree;
                }
                TreeVars treeType = TreeTypeGetter.getTree(world, oldTree);
                if (treeType != null) {
                    if (!GenTree.tryGenerate(new TreePos(world, random, chunkscan, pos, treeType))) continue;
                    continue;
                }
                this.doGen(oldTree, world, chunkscan, pos, random, chunkscan);
            }
        }
        for (WorldGenerator shrub : shrubgenerators) {
            pos = chunkscan.getRandomNotGenerated(world.field_73012_v);
            if (pos == null) break;
            shrub.func_180709_b(world, world.field_73012_v, (BlockPos)pos);
        }
    }

    public WorldGenerator getTree(Random random, Biome biome, ChunkScan chunkscan, boolean doReplace) {
        if (biome instanceof SubBiome) {
            return ((SubBiome)biome).getTree(chunkscan, doReplace, random);
        }
        return biome.func_150567_a(random);
    }

    public boolean customTree(Random random, BlockPos pos) {
        double noise2;
        double noise = this.simplex2.noise(pos.func_177958_n() / 32, pos.func_177952_p() / 32) * 0.5 + 0.5;
        double rand = random.nextFloat();
        return rand < (noise2 = noise - (noise - OverworldGenConfig.treeReplacementRate) * OverworldGenConfig.simplexTreeScale);
    }

    public static void addRoots(World world, BlockPos pos, Random random, ChunkScan scan) {
        if (OverworldGenConfig.addRoots) {
            IBlockState state = world.func_180495_p(pos.func_177984_a());
            Block block = state.func_177230_c();
            int blockhash = block.hashCode();
            if (block instanceof BlockLog) {
                int size = 0;
                while (world.func_180495_p(pos.func_177981_b(size)).hashCode() == blockhash) {
                    size += 3;
                }
                GenTree.genRootsOnly(new TreePos(world, random, scan, pos, new RootsOnly(world, state, size)));
            }
        }
    }

    public static void addRoots(World world, BlockPos pos, Random random, ChunkScan scan, int size) {
        IBlockState state;
        Block block;
        if (OverworldGenConfig.addRoots && (block = (state = world.func_180495_p(pos.func_177984_a())).func_177230_c()) instanceof BlockLog) {
            GenTree.genRootsOnly(new TreePos(world, random, scan, pos, new RootsOnly(world, state, size)));
        }
    }

    public void doGen(WorldGenerator tree, World world, ChunkScan chunkscan, BlockPos pos, Random random, ChunkScan scan) throws Exception {
        if (chunkscan.checkGenerated(pos, 2) && chunkscan.canGrowOnCheck(pos, 1) && tree != null) {
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            tree.func_180709_b(world, world.field_73012_v, pos);
            chunkscan.setGenerated(pos, 4);
            OverworldGen.addRoots(world, pos, random, chunkscan);
        }
    }
}

