/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import wtf.api.Replacer;
import wtf.blocks.AnimatedBlock;
import wtf.init.WTFBlocks;
import wtf.utilities.GenMethods;
import wtf.utilities.Simplex;

public class LavaReplacer
extends Replacer {
    private static Simplex simplex = new Simplex(5000);

    public LavaReplacer(Block block) {
        super(block);
    }

    @Override
    public boolean isNonSolidAndReplacement(Chunk chunk, BlockPos pos, Block oldBlock) {
        if (pos.func_177956_o() < 11) {
            double x = pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = pos.func_177952_p();
            double noise = simplex.noise(x / 25.0, y, z / 25.0) * 5.0 + 5.0;
            World world = chunk.func_177412_p();
            Biome biome = world.getBiomeForCoordsBody(pos);
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
                GenMethods.setBlockState(world, pos, Blocks.field_150355_j.func_176223_P());
            } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                if (noise < 4.0) {
                    GenMethods.setBlockState(world, pos, Blocks.field_150343_Z.func_176223_P());
                } else {
                    GenMethods.setBlockState(world, pos, Blocks.field_150347_e.func_176223_P());
                }
            } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                if (noise < 4.0) {
                    GenMethods.setBlockState(world, pos, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND));
                } else if (noise < 7.0) {
                    GenMethods.setBlockState(world, pos, WTFBlocks.decoStone.func_176223_P().func_177226_a(AnimatedBlock.TYPE, (Comparable)((Object)AnimatedBlock.ANIMTYPE.LAVA_CRUST)));
                }
            }
            return false;
        }
        return true;
    }
}

