/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.api.PopulationGenerator;
import wtf.config.CaveBiomesConfig;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.AbstractDungeonType;
import wtf.worldgen.caves.CaveBiomeGenMethods;
import wtf.worldgen.caves.CaveProfile;
import wtf.worldgen.caves.CaveTypeRegister;

public class DungeonPopulator
extends PopulationGenerator {
    @Override
    public void generate(World world, ChunkCoords coords, Random random, ChunkScan chunkscan) {
        CaveBiomeGenMethods gen = new CaveBiomeGenMethods(world, coords, random);
        CaveListWrapper cave = DungeonPopulator.getLargestCave(chunkscan);
        if (cave == null) {
            return;
        }
        CaveProfile profile = CaveTypeRegister.getCaveProfile(cave.getBiome(world));
        AbstractDungeonType dungeon = profile.getDungeonForCave(gen, random, cave, (int)chunkscan.surfaceAvg);
        if (dungeon != null && random.nextFloat() < CaveBiomesConfig.dungeonChance) {
            System.out.println("Generating dungeon " + dungeon.name + " @ " + cave.getCenter().x + " " + cave.getCenter().floor + " " + cave.getCenter().z);
            for (BlockPos pos : cave.wall) {
                int x = pos.func_177958_n() >> 4;
                int z = pos.func_177958_n() >> 4;
                if (x != coords.getChunkX() || z != coords.getChunkX()) {
                    dungeon.generateWall(gen, random, pos, (float)pos.func_177956_o() / (float)chunkscan.surfaceAvg, pos.func_177956_o() - (int)cave.getAvgFloor());
                    continue;
                }
                dungeon.generateWall(gen, random, pos, (float)pos.func_177956_o() / (float)chunkscan.surfaceAvg, pos.func_177956_o() - (int)cave.getAvgFloor());
            }
            for (AdjPos adj : cave.adjacentWall) {
                dungeon.generateAdjacentWall(gen, random, adj, (float)adj.func_177956_o() / (float)chunkscan.surfaceAvg, adj.func_177956_o() - cave.getCenter().floor);
            }
            for (CavePosition position : cave.cave) {
                if (position.alreadyGenerated) continue;
                DungeonPopulator.generateDungeon(gen, random, dungeon, position, (float)((double)((float)cave.getAvgFloor()) / chunkscan.surfaceAvg), position == cave.getCenter());
                if (!dungeon.genOver) continue;
                position.alreadyGenerated = true;
            }
        }
        gen.blocksToSet.setBlockSet();
    }

    public static void generateDungeon(CaveBiomeGenMethods gen, Random random, AbstractDungeonType dungeon, CavePosition pos, float depth, boolean center) {
        dungeon.generateFloor(gen, random, pos.getFloorPos(), depth);
        dungeon.generateCeiling(gen, random, pos.getCeilingPos(), depth);
        if ((float)random.nextInt(100) < (float)dungeon.ceilingaddonchance + (1.0f - depth) * 5.0f) {
            dungeon.generateCeilingAddons(gen, random, pos.getCeilingPos().func_177977_b(), depth);
        }
        if ((float)random.nextInt(100) < (float)dungeon.flooraddonchance + (1.0f - depth) * 5.0f) {
            dungeon.generateCeilingAddons(gen, random, pos.getCeilingPos().func_177977_b(), depth);
        }
        if (center) {
            dungeon.generateCenter(gen, random, pos, depth);
        }
    }

    public static CaveListWrapper getLargestCave(ChunkScan chunkscan) {
        for (CaveListWrapper wrappedcave : chunkscan.caveset) {
            for (int loop = 14; loop > 7; --loop) {
                if (wrappedcave.cave.size() <= loop * loop || wrappedcave.getSizeX() <= loop - 1 || wrappedcave.getSizeZ() <= loop - 1 || wrappedcave.getCenter() == null || !((double)(wrappedcave.getSizeX() * wrappedcave.getSizeZ() / wrappedcave.cave.size()) > 0.8) || !(wrappedcave.getAvgCeiling() - wrappedcave.getAvgFloor() > 3.0) || !(wrappedcave.getAvgCeiling() - wrappedcave.getAvgFloor() < 8.0)) continue;
                return wrappedcave;
            }
        }
        return null;
    }
}

