/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import wtf.utilities.Simplex;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.caves.CaveBiomeGenMethods;
import wtf.worldgen.trees.TreeTypeGetter;
import wtf.worldgen.trees.TreeVars;

public abstract class AbstractCaveType {
    public int dungeonPercentChance = 5;
    public final String name;
    protected static Simplex simplex = new Simplex(5000);
    public final int ceilingaddonchance;
    public final int flooraddonchance;

    public AbstractCaveType(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        this.name = name;
        this.ceilingaddonchance = ceilingAddonPercentChance;
        this.flooraddonchance = floorAddonPercentChance;
    }

    public abstract void generateCeiling(CaveBiomeGenMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateFloor(CaveBiomeGenMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateCeilingAddons(CaveBiomeGenMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateFloorAddons(CaveBiomeGenMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateWall(CaveBiomeGenMethods var1, Random var2, BlockPos var3, float var4, int var5);

    public void generateAdjacentWall(CaveBiomeGenMethods gen, Random random, AdjPos pos, float depth, int height) {
    }

    protected final double getNoise(BlockPos pos, double returnSize, float scale) {
        double x = (float)pos.func_177958_n() * scale;
        double y = (float)pos.func_177956_o() * scale;
        double z = (float)pos.func_177952_p() * scale;
        double noise = simplex.noise(x, y, z) * (returnSize /= 2.0) + returnSize;
        return noise;
    }

    public void setTopBlock(CaveBiomeGenMethods gen, Random random, SurfacePos pos) {
    }

    public TreeVars getTreeType(World world, ChunkScan scan, WorldGenAbstractTree oldTree) {
        return TreeTypeGetter.getTree(world, (WorldGenerator)oldTree);
    }
}

