/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.trees.TreePos;
import wtf.worldscan.CoreWorldGenListener;

public class ChunkScan {
    public final SurfacePos[][] surface;
    public final World world;
    public final int chunkX;
    public final int chunkZ;
    public final double surfaceAvg;
    public final ArrayList<CaveListWrapper> caveset;
    private ArrayList<BlockPos> underwater = null;
    int waterHash = Material.field_151586_h.hashCode();
    int lavaHash = Material.field_151587_i.hashCode();
    Block[] base = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, WTFBlocks.mossyDirt};
    HashSet<Block> canGrowOn = new HashSet<Block>(Arrays.asList(this.base));

    public ChunkScan(World world, SurfacePos[][] var, int x, int z, int avg, ArrayList<CaveListWrapper> caveareas) {
        this.surface = var;
        this.chunkX = x;
        this.chunkZ = z;
        this.surfaceAvg = avg;
        this.world = world;
        this.caveset = caveareas;
    }

    public Block getBlockInChunk(int x, int z) {
        return this.world.func_180495_p((BlockPos)this.surface[x][z]).func_177230_c();
    }

    public SurfacePos getSurfacePosFromWorldCoords(int worldx, int worldz) {
        int x = worldx - this.chunkX;
        int z = worldz - this.chunkZ;
        if (x > -1 && x < 16 && z > -1 && z < 16) {
            return this.surface[x][z];
        }
        return null;
    }

    public Block getBlockInWorld(int x, int y, int z) {
        return this.world.func_180495_p(new BlockPos(this.chunkX + x, y, this.chunkZ + z)).func_177230_c();
    }

    public boolean checkPositionForTreeGen(World world, TreePos tree) throws Exception {
        int x = tree.pos.func_177958_n() - this.chunkX;
        int z = tree.pos.func_177952_p() - this.chunkZ;
        IBlockState up1 = world.func_180495_p(new BlockPos(tree.pos.func_177958_n(), tree.pos.func_177956_o() + 1, tree.pos.func_177952_p()));
        int tradceil = MathHelper.func_76143_f((double)tree.trunkRadius);
        int trunkRadius = tradceil * tradceil;
        int addRad = MathHelper.func_76143_f((double)((double)tree.type.genBuffer + tree.type.getBranchLength(tree.scale, tree.trunkHeight, tree.trunkHeight / 2.0) + tree.type.leafRad / 2.0));
        int fullRadius = addRad > 0 ? tradceil + addRad : tradceil;
        int fullrad2 = fullRadius * fullRadius;
        int materialHash = up1.func_185904_a().hashCode();
        if (!tree.type.waterGenerate ? materialHash == this.waterHash : materialHash != this.waterHash) {
            return false;
        }
        if (materialHash == this.lavaHash) {
            return false;
        }
        int canGrow = 0;
        for (int loopX = -fullRadius; loopX < fullRadius; ++loopX) {
            for (int loopZ = -fullRadius; loopZ < fullRadius; ++loopZ) {
                SurfacePos pos;
                ChunkScan adjacentScan;
                int scanx = loopX + x;
                int scanz = loopZ + z;
                int rad = loopX * loopX + loopZ * loopZ;
                if (rad < trunkRadius) {
                    if (scanx < 16 && scanx > -1 && scanz < 16 && scanz > -1) {
                        if (this.surface[scanx][scanz].generated || MathHelper.func_76130_a((int)(this.surface[scanx][scanz].func_177956_o() - tree.pos.func_177956_o())) > 4) {
                            return false;
                        }
                        if (tree.type.canGrowOn.contains(this.getBlockInChunk(scanx, scanz))) {
                            ++canGrow;
                            continue;
                        }
                        --canGrow;
                        continue;
                    }
                    adjacentScan = CoreWorldGenListener.getChunkScan(world, new ChunkCoords(scanx + this.chunkX >> 4, scanz + this.chunkZ >> 4));
                    if (adjacentScan != null) {
                        pos = adjacentScan.getSurfacePosFromWorldCoords(scanx + this.chunkX, scanz + this.chunkZ);
                        if (pos.generated) {
                            return false;
                        }
                        if (MathHelper.func_76130_a((int)(pos.func_177956_o() - tree.pos.func_177956_o())) <= 4) continue;
                        return false;
                    }
                    return false;
                }
                if (rad >= fullrad2) continue;
                if (scanx < 16 && scanx > -1 && scanz < 16 && scanz > -1) {
                    if (!this.surface[scanx][scanz].generated) continue;
                    return false;
                }
                adjacentScan = CoreWorldGenListener.getChunkScan(world, new ChunkCoords(scanx + this.chunkX >> 4, scanz + this.chunkZ >> 4));
                if (adjacentScan != null) {
                    pos = adjacentScan.getSurfacePosFromWorldCoords(scanx + this.chunkX, scanz + this.chunkZ);
                    if (!pos.generated) continue;
                    return false;
                }
                return false;
            }
        }
        return canGrow > 0;
    }

    public boolean canGrowOnCheck(BlockPos treepos, int checkRad) throws Exception {
        int x = treepos.func_177958_n() - this.chunkX;
        int z = treepos.func_177952_p() - this.chunkZ;
        IBlockState up1 = this.world.func_180495_p(treepos.func_177984_a());
        int tradceil = 2;
        int trunkRadius = tradceil * tradceil;
        int fullRadius = checkRad;
        int fullrad2 = fullRadius * fullRadius;
        int materialHash = up1.func_185904_a().hashCode();
        if (materialHash == this.waterHash) {
            return false;
        }
        if (materialHash == this.lavaHash) {
            return false;
        }
        int canGrow = 0;
        for (int loopX = -fullRadius; loopX < fullRadius; ++loopX) {
            for (int loopZ = -fullRadius; loopZ < fullRadius; ++loopZ) {
                SurfacePos pos;
                ChunkScan adjacentScan;
                int scanx = loopX + x;
                int scanz = loopZ + z;
                int rad = loopX * loopX + loopZ * loopZ;
                if (rad < trunkRadius) {
                    if (scanx < 16 && scanx > -1 && scanz < 16 && scanz > -1) {
                        if (this.surface[scanx][scanz].generated || MathHelper.func_76130_a((int)(this.surface[scanx][scanz].func_177956_o() - treepos.func_177956_o())) > 4) {
                            return false;
                        }
                        if (this.canGrowOn.contains(this.getBlockInChunk(scanx, scanz))) {
                            ++canGrow;
                            continue;
                        }
                        --canGrow;
                        continue;
                    }
                    adjacentScan = CoreWorldGenListener.getChunkScan(this.world, new ChunkCoords(scanx + this.chunkX >> 4, scanz + this.chunkZ >> 4));
                    if (adjacentScan != null) {
                        pos = adjacentScan.getSurfacePosFromWorldCoords(scanx + this.chunkX, scanz + this.chunkZ);
                        if (pos.generated) {
                            return false;
                        }
                        if (MathHelper.func_76130_a((int)(pos.func_177956_o() - treepos.func_177956_o())) <= 4) continue;
                        return false;
                    }
                    return false;
                }
                if (rad >= fullrad2) continue;
                if (scanx < 16 && scanx > -1 && scanz < 16 && scanz > -1) {
                    if (!this.surface[scanx][scanz].generated) continue;
                    return false;
                }
                adjacentScan = CoreWorldGenListener.getChunkScan(this.world, new ChunkCoords(scanx + this.chunkX >> 4, scanz + this.chunkZ >> 4));
                if (adjacentScan != null) {
                    pos = adjacentScan.getSurfacePosFromWorldCoords(scanx + this.chunkX, scanz + this.chunkZ);
                    if (!pos.generated) continue;
                    return false;
                }
                return false;
            }
        }
        return canGrow > 0;
    }

    public SurfacePos getRandomNotGenerated(Random random) {
        for (int tryloop = 0; tryloop < 5; ++tryloop) {
            IBlockState up1;
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            if (this.surface[x][z].generated || (up1 = this.world.func_180495_p(this.surface[x][z].func_177984_a())).func_185904_a().hashCode() == this.lavaHash && up1.func_185904_a().hashCode() == this.waterHash) continue;
            return this.surface[x][z];
        }
        return null;
    }

    public void setGenerated(int x, int z) {
        int setX = x - this.chunkX;
        int setZ = z - this.chunkZ;
        if (setX < 16 && setX > -1 && setZ < 16 && setZ > -1) {
            this.surface[setX][setZ].generated = true;
        }
    }

    public ArrayList<BlockPos> getWaterList() {
        if (this.underwater == null) {
            this.underwater = new ArrayList();
            Chunk chunk = this.world.func_72964_e(this.chunkX, this.chunkZ);
            for (int xloop = 0; xloop < 16; ++xloop) {
                for (int zloop = 0; zloop < 16; ++zloop) {
                    if (chunk.func_177435_g(this.surface[xloop][zloop].func_177984_a()).func_185904_a().hashCode() != this.waterHash) continue;
                    this.underwater.add(this.surface[xloop][zloop]);
                }
            }
        }
        return this.underwater;
    }

    public void setGenerated(BlockPos pos, int radius) throws Exception {
        int x = pos.func_177958_n() - this.chunkX;
        int z = pos.func_177952_p() - this.chunkZ;
        int radius2 = radius * radius;
        for (int loopX = -radius; loopX < radius; ++loopX) {
            for (int loopZ = -radius; loopZ < radius; ++loopZ) {
                int scanx = loopX + x;
                int scanz = loopZ + z;
                int rad = loopX * loopX + loopZ * loopZ;
                if (rad >= radius2) continue;
                if (scanx < 16 && scanx > -1 && scanz < 16 && scanz > -1) {
                    this.surface[scanx][scanz].generated = true;
                    continue;
                }
                ChunkScan adjacentScan = CoreWorldGenListener.getChunkScan(this.world, new ChunkCoords(scanx + this.chunkX >> 4, scanz + this.chunkZ >> 4));
                if (adjacentScan == null) continue;
                adjacentScan.getSurfacePosFromWorldCoords((int)(scanx + this.chunkX), (int)(scanz + this.chunkZ)).generated = true;
            }
        }
    }

    public boolean checkGenerated(BlockPos pos, int radius) throws Exception {
        int x = pos.func_177958_n() - this.chunkX;
        int z = pos.func_177952_p() - this.chunkZ;
        int radius2 = radius * radius;
        for (int loopX = -radius; loopX < radius; ++loopX) {
            for (int loopZ = -radius; loopZ < radius; ++loopZ) {
                ChunkScan adjacentScan;
                int scanx = loopX + x;
                int scanz = loopZ + z;
                int rad = loopX * loopX + loopZ * loopZ;
                if (rad >= radius2 || !(scanx < 16 && scanx > -1 && scanz < 16 && scanz > -1 ? this.surface[scanx][scanz].generated : (adjacentScan = CoreWorldGenListener.getChunkScan(this.world, new ChunkCoords(scanx + this.chunkX >> 4, scanz + this.chunkZ >> 4))) != null && adjacentScan.getSurfacePosFromWorldCoords((int)(scanx + this.chunkX), (int)(scanz + this.chunkZ)).generated)) continue;
                return false;
            }
        }
        return true;
    }
}

