/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import wtf.utilities.wrappers.ChunkCoords;

public class ChunkDividedHashMap {
    private final HashMap<ChunkCoords, HashMap<BlockPos, IBlockState>> hashmap = new HashMap();
    private final World world;

    public ChunkDividedHashMap(World world, ChunkCoords coords) {
        this.hashmap.put(coords, new HashMap());
        this.world = world;
    }

    public void put(BlockPos pos, IBlockState state) {
        ChunkCoords coords = new ChunkCoords(pos);
        HashMap<BlockPos, IBlockState> submap = this.hashmap.get(coords);
        if (submap != null) {
            submap.put(pos, state);
        } else {
            HashMap<BlockPos, IBlockState> newMap = new HashMap<BlockPos, IBlockState>();
            newMap.put(pos, state);
            this.hashmap.put(coords, newMap);
        }
    }

    public void putAll(HashMap<BlockPos, IBlockState> mapIn) {
        for (Map.Entry<BlockPos, IBlockState> entry : mapIn.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public IBlockState get(BlockPos pos) {
        ChunkCoords coords = new ChunkCoords(pos);
        if (this.hashmap.containsKey(coords)) {
            return this.hashmap.get(new ChunkCoords(pos)).get(pos);
        }
        return null;
    }

    public void setBlockSet() {
        for (Map.Entry<ChunkCoords, HashMap<BlockPos, IBlockState>> subMap : this.hashmap.entrySet()) {
            Chunk chunk = subMap.getKey().getChunk(this.world);
            Iterator<Map.Entry<BlockPos, IBlockState>> iterator = subMap.getValue().entrySet().iterator();
            Map.Entry<BlockPos, IBlockState> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getKey().func_177956_o() <= 0 && entry.getKey().func_177956_o() >= this.world.func_72800_K()) continue;
                BlockPos pos = entry.getKey();
                IBlockState state = entry.getValue();
                ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[pos.func_177956_o() >> 4];
                if (extendedblockstorage != Chunk.field_186036_a) {
                    if (state != null) {
                        extendedblockstorage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
                    }
                } else {
                    chunk.func_177436_a(entry.getKey(), entry.getValue());
                }
                this.world.markAndNotifyBlock(pos, chunk, state, state, 2);
            }
        }
    }
}

