/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CavePosition;

public class CaveListWrapper {
    public final ArrayList<CavePosition> cave = new ArrayList();
    public final ArrayList<BlockPos> wall;
    public final ArrayList<AdjPos> adjacentWall;
    private int totalFloor = 0;
    private int totalCeiling = 0;
    private int totalX = 0;
    private int totalZ = 0;
    int minFloor;
    int minCeiling;
    int minX;
    int minZ;
    int maxFloor;
    int maxCeiling;
    int maxX;
    int maxZ;
    CavePosition center = null;

    public CaveListWrapper(CavePosition firstposition, ArrayList<BlockPos> wallpos, ArrayList<AdjPos> adjacent) {
        this.wall = new ArrayList<BlockPos>(wallpos);
        this.adjacentWall = new ArrayList<AdjPos>(adjacent);
        this.cave.add(firstposition);
        this.totalFloor += firstposition.floor;
        this.totalCeiling += firstposition.ceiling;
        this.totalX += firstposition.x;
        this.totalZ += firstposition.z;
        this.minFloor = firstposition.floor;
        this.minCeiling = firstposition.ceiling;
        this.minX = firstposition.x;
        this.minZ = firstposition.z;
        this.maxFloor = firstposition.floor;
        this.maxCeiling = firstposition.ceiling;
        this.maxX = firstposition.x;
        this.maxZ = firstposition.z;
    }

    public CaveListWrapper addPos(CavePosition pos, ArrayList<BlockPos> wallpos, ArrayList<AdjPos> adjacent) {
        int listFloor = this.cave.get((int)(this.cave.size() - 1)).floor;
        int listCeiling = this.cave.get((int)(this.cave.size() - 1)).ceiling;
        int lastX = this.cave.get((int)(this.cave.size() - 1)).x;
        int lastZ = this.cave.get((int)(this.cave.size() - 1)).z;
        if (MathHelper.func_76135_e((float)(listFloor - pos.floor)) < 3.0f && MathHelper.func_76135_e((float)(listCeiling - pos.ceiling)) < 3.0f && MathHelper.func_76135_e((float)(lastX - pos.x)) < 4.0f && MathHelper.func_76135_e((float)(lastZ - pos.z)) < 4.0f) {
            this.cave.add(pos);
            this.wall.addAll(wallpos);
            this.adjacentWall.addAll(adjacent);
            this.totalFloor += pos.floor;
            this.totalCeiling += pos.ceiling;
            this.totalX += pos.x;
            this.totalZ += pos.z;
            this.minFloor = this.minFloor < pos.floor ? this.minFloor : pos.floor;
            this.minCeiling = this.minCeiling < pos.ceiling ? this.minCeiling : pos.ceiling;
            this.minX = this.minX < pos.x ? this.minX : pos.x;
            this.minZ = pos.z < pos.z ? this.minZ : pos.z;
            this.maxFloor = this.maxFloor > pos.floor ? this.maxFloor : pos.floor;
            this.maxCeiling = this.maxCeiling > pos.ceiling ? this.maxCeiling : pos.ceiling;
            this.maxX = this.maxX > pos.x ? this.maxX : pos.x;
            this.maxZ = this.maxZ > pos.z ? this.maxZ : pos.z;
            return this;
        }
        return null;
    }

    public void addWall(BlockPos wallpos, AdjPos adjpos) {
        this.wall.add(wallpos);
        this.adjacentWall.add(adjpos);
    }

    public double getAvgFloor() {
        return this.totalFloor / this.cave.size();
    }

    public double getAvgCeiling() {
        return this.totalCeiling / this.cave.size();
    }

    public double getAvgX() {
        return this.totalX / this.cave.size();
    }

    public double getAvgZ() {
        return this.totalZ / this.cave.size();
    }

    public Biome getBiome(World world) {
        return world.getBiomeForCoordsBody(new BlockPos(this.getAvgX(), this.getAvgFloor(), this.getAvgZ()));
    }

    public int getSizeX() {
        return MathHelper.func_76130_a((int)(this.maxX - this.minX));
    }

    public int getSizeZ() {
        return MathHelper.func_76130_a((int)(this.maxZ - this.minZ));
    }

    public CavePosition getCenter() {
        if (this.center != null) {
            return this.center;
        }
        int x = MathHelper.func_76128_c((double)this.getAvgX());
        int z = MathHelper.func_76128_c((double)this.getAvgZ());
        for (CavePosition pos : this.cave) {
            if (pos.x != x || pos.z != z) continue;
            this.center = pos;
            return pos;
        }
        return null;
    }

    public ArrayList<CavePosition> getCircle(CavePosition center, float radius) {
        ArrayList<CavePosition> newlist = new ArrayList<CavePosition>();
        for (CavePosition pos : this.cave) {
            int distance = (pos.x - center.x) * (pos.x - center.x) + (pos.z - center.z) * (pos.z - center.z);
            if (!((float)distance < radius * radius)) continue;
            newlist.add(pos);
        }
        return newlist;
    }

    public CavePosition getRandomPosition(Random random) {
        return this.cave.get(random.nextInt(this.cave.size()));
    }
}

