/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.BlockSnapshot;

public class GenMethods {
    public static HashSet<Block> getAreaHashSet(World world, BlockPos pos, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (int xloop = xmin; xloop < xmax + 1; ++xloop) {
            for (int yloop = ymin; yloop < ymax + 1; ++yloop) {
                for (int zloop = zmin; zloop < zmax + 1; ++zloop) {
                    blocks.add(world.func_180495_p(new BlockPos(pos.func_177958_n() + xloop, pos.func_177956_o() + yloop, pos.func_177952_p() + zloop)).func_177230_c());
                }
            }
        }
        return blocks;
    }

    public static boolean setBlockState(World world, BlockPos pos, IBlockState newState) {
        int flags = 0;
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        BlockSnapshot blockSnapshot = null;
        if (world.captureBlockSnapshots && !world.field_72995_K) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos, (int)flags);
            world.capturedBlockSnapshots.add(blockSnapshot);
        }
        IBlockState oldState = world.func_180495_p(pos);
        int oldLight = oldState.getLightValue((IBlockAccess)world, pos);
        int oldOpacity = oldState.getLightOpacity((IBlockAccess)world, pos);
        IBlockState iblockstate = chunk.func_177436_a(pos, newState);
        if (iblockstate == null) {
            if (blockSnapshot != null) {
                world.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        if (newState.getLightOpacity((IBlockAccess)world, pos) != oldOpacity || newState.getLightValue((IBlockAccess)world, pos) != oldLight) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x(pos);
            world.field_72984_F.func_76319_b();
        }
        if (blockSnapshot == null) {
            world.markAndNotifyBlock(pos, chunk, iblockstate, newState, flags);
        }
        return true;
    }
}

