/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.OrePos;

public class OreGenVein
extends OreGenAbstract {
    public final int veinLength;
    public final int veinWidth;
    public final int veinHeight;
    public final float veinPitch;
    public static final float pi8 = 0.3926991f;
    public static final float pi2 = 1.5707964f;
    public static final float pi4 = 0.7853982f;
    public static final float pi = (float)Math.PI;

    public OreGenVein(IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, int length, int width, int height, float pitch, boolean genDense) {
        super(blockstate, maxGenRangeHeight, minGenRangeHeight, maxPerChunk, minPerChunk, genDense);
        this.veinLength = length;
        this.veinWidth = width;
        this.veinHeight = height;
        this.veinPitch = pitch;
    }

    @Override
    public void doOreGen(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        int z;
        int y;
        int x;
        int blocksReq = this.blocksReq();
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); blocksPerChunk > blocksReq || blocksPerChunk > 0 && random.nextInt(blocksReq) < blocksPerChunk; blocksPerChunk -= this.genVein(world, map, random, chunkscan, new BlockPos(x, y, z))) {
            x = coords.getWorldX() + random.nextInt(16);
            z = coords.getWorldZ() + random.nextInt(16);
            y = this.getGenStartHeight(chunkscan.surfaceAvg, random);
        }
    }

    @Override
    public int genVein(World world, ChunkDividedOreMap map, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        int length = this.veinLength * random.nextInt(5) - 2;
        int blocksSet = 0;
        float pitchY = this.veinPitch + random.nextFloat() * 0.7853982f - 0.3926991f;
        float pitchX = random.nextFloat() * (float)Math.PI;
        float vecY = MathHelper.func_76134_b((float)pitchY);
        float vecX = MathHelper.func_76134_b((float)pitchX) * MathHelper.func_76126_a((float)pitchY);
        float vecZ = MathHelper.func_76126_a((float)pitchX) * MathHelper.func_76126_a((float)pitchY);
        float vecWidthY = MathHelper.func_76134_b((float)(pitchY + 0.7853982f));
        float vecWidthX = MathHelper.func_76134_b((float)(pitchX + 0.7853982f));
        float vecWidthZ = MathHelper.func_76126_a((float)(pitchX + 0.7853982f));
        for (int widthLoop = 0; widthLoop < this.veinWidth; ++widthLoop) {
            for (int heightLoop = 0; heightLoop < this.veinHeight; ++heightLoop) {
                double xpos = (float)pos.func_177958_n() + (float)widthLoop * vecWidthX;
                double zpos = (float)pos.func_177952_p() + (float)widthLoop * vecWidthZ;
                double ypos = (float)pos.func_177956_o() + (float)heightLoop * vecWidthY;
                for (int lengthLoop = 0; lengthLoop < length; ++lengthLoop) {
                    int densityToSet;
                    int n = densityToSet = this.genDenseOres ? (densityToSet = this.getDensityToSet(random, ypos / scan.surfaceAvg)) : 0;
                    if (random.nextFloat() < this.veinDensity.floatValue()) {
                        blocksSet += densityToSet + 1;
                        map.put(new OrePos(xpos, ypos, zpos, densityToSet), this.oreBlock);
                    }
                    xpos += (double)vecX;
                    zpos += (double)vecZ;
                    ypos += (double)vecY;
                }
            }
        }
        return blocksSet;
    }

    @Override
    public int blocksReq() {
        return (int)((float)(this.veinLength * this.veinWidth * this.veinHeight) * this.veinDensity.floatValue());
    }
}

