/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;

public class OreGenUnderWater
extends OreGenAbstract {
    private final OreGenAbstract veinType;

    public OreGenUnderWater(OreGenAbstract vein, IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, boolean denseGen) {
        super(blockstate, maxGenRangeHeight, minGenRangeHeight, maxPerChunk, minPerChunk, denseGen);
        this.veinType = vein;
    }

    @Override
    public void doOreGen(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        ArrayList<BlockPos> list = chunkscan.getWaterList();
        if (list.size() > 0) {
            BlockPos pos;
            int blocksReq = this.blocksReq();
            for (int numToGenerate = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); numToGenerate > blocksReq || numToGenerate > 0 && random.nextInt(blocksReq) < numToGenerate; numToGenerate -= this.veinType.genVein(world, map, random, chunkscan, pos)) {
                pos = list.get(random.nextInt(list.size()));
            }
        }
    }

    @Override
    public int genVein(World world, ChunkDividedOreMap map, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        return 0;
    }

    @Override
    public int blocksReq() {
        return this.veinType.blocksReq();
    }
}

