/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.OrePos;

public class OreGenSingle
extends OreGenAbstract {
    public OreGenSingle(IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, boolean genDense) {
        super(blockstate, maxGenRangeHeight, minGenRangeHeight, maxPerChunk, minPerChunk, genDense);
    }

    @Override
    public void doOreGen(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        int z;
        int y;
        int x;
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); blocksPerChunk > 0; blocksPerChunk -= this.genVein(world, map, random, chunkscan, new BlockPos(x, y, z))) {
            x = coords.getWorldX() + random.nextInt(16);
            y = this.getGenStartHeight(chunkscan.surfaceAvg, random);
            z = coords.getWorldZ() + random.nextInt(16);
        }
    }

    @Override
    public int genVein(World world, ChunkDividedOreMap map, Random random, ChunkScan scan, BlockPos pos) {
        int densityToSet = this.genDenseOres ? this.getDensityToSet(random, (double)pos.func_177956_o() / scan.surfaceAvg) : 0;
        map.put(new OrePos(pos, densityToSet), this.oreBlock);
        return densityToSet + 1;
    }

    @Override
    public int blocksReq() {
        return 1;
    }
}

