/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.OrePos;

public class OreGenCluster
extends OreGenAbstract {
    public OreGenCluster(IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, boolean genDense) {
        super(blockstate, maxGenRangeHeight, minGenRangeHeight, maxPerChunk, minPerChunk, genDense);
    }

    @Override
    public void doOreGen(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        int z;
        int y;
        int x;
        int blocksReq = (int)(6.0f * this.veinDensity.floatValue());
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); blocksPerChunk > blocksReq || blocksPerChunk > 0 && random.nextInt(blocksReq) < blocksPerChunk; blocksPerChunk -= this.genVein(world, map, random, chunkscan, new BlockPos(x, y, z))) {
            x = coords.getWorldX() + random.nextInt(12) + 2;
            y = this.getGenStartHeight(chunkscan.surfaceAvg, random);
            z = coords.getWorldZ() + random.nextInt(16);
        }
    }

    @Override
    public int genVein(World world, ChunkDividedOreMap map, Random random, ChunkScan chunkscan, BlockPos pos) throws Exception {
        int blocksPerChunk = 0;
        double depth = (double)pos.func_177956_o() / chunkscan.surfaceAvg;
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(map, world, random, pos, depth);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(map, world, random, pos.func_177984_a(), depth);
        }
        blocksPerChunk += this.genStarPosition(map, world, random, pos.func_177977_b(), depth);
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(map, world, random, pos.func_177978_c(), depth);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(map, world, random, pos.func_177968_d(), depth);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(map, world, random, pos.func_177974_f(), depth);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(map, world, random, pos.func_177976_e(), depth);
        }
        return blocksPerChunk;
    }

    private int genStarPosition(ChunkDividedOreMap map, World world, Random random, BlockPos pos, double depth) throws Exception {
        int densityToSet = this.genDenseOres ? this.getDensityToSet(random, depth) : 0;
        map.put(new OrePos(pos, densityToSet), this.oreBlock);
        return densityToSet + 1;
    }

    @Override
    public int blocksReq() {
        return (int)(6.0f * this.veinDensity.floatValue());
    }
}

