/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.OrePos;

public class OreGenCloud
extends OreGenAbstract {
    public final double radius;

    public OreGenCloud(IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, int diameter, boolean genDense) {
        super(blockstate, maxGenRangeHeight, minGenRangeHeight, maxPerChunk, minPerChunk, genDense);
        this.radius = (float)diameter / 2.0f;
    }

    @Override
    public void doOreGen(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        int oriZ;
        int oriY;
        int oriX;
        int blocksReq = this.blocksReq();
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); blocksPerChunk > blocksReq || blocksPerChunk > 0 && random.nextInt(blocksReq) < blocksPerChunk; blocksPerChunk -= this.genVein(world, map, random, chunkscan, new BlockPos(oriX, oriY, oriZ))) {
            oriX = coords.getWorldX() + random.nextInt(16);
            oriZ = coords.getWorldZ() + random.nextInt(16);
            oriY = this.getGenStartHeight(chunkscan.surfaceAvg, random);
        }
    }

    @Override
    public int genVein(World world, ChunkDividedOreMap map, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        int blocksSet = 0;
        int xloop = (int)(-this.radius);
        while ((double)xloop < this.radius + 1.0) {
            int yloop = (int)(-this.radius);
            while ((double)yloop < this.radius + 1.0) {
                int zloop = (int)(-this.radius);
                while ((double)zloop < this.radius + 1.0) {
                    double distance = MathHelper.func_76133_a((double)(xloop * xloop + yloop * yloop + zloop * zloop));
                    if (distance < this.radius) {
                        int densityToSet = this.genDenseOres ? this.getDensityToSet(random, (double)(pos.func_177956_o() + yloop) / scan.surfaceAvg) : 0;
                        if (random.nextFloat() < this.veinDensity.floatValue()) {
                            blocksSet += densityToSet + 1;
                            map.put(new OrePos(pos.func_177958_n() + xloop, pos.func_177956_o() + yloop, pos.func_177952_p() + zloop, densityToSet), this.oreBlock);
                        }
                    }
                    ++zloop;
                }
                ++yloop;
            }
            ++xloop;
        }
        return blocksSet;
    }

    @Override
    public int blocksReq() {
        return (int)(4.188685485031271 * this.radius * this.radius * this.radius * (double)this.veinDensity.floatValue());
    }
}

