/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;

public class OreGenCaveFloor
extends OreGenAbstract {
    private final OreGenAbstract veinType;
    private final List<surface> surfaceList;

    public OreGenCaveFloor(OreGenAbstract vein, IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, boolean genDense, List<surface> list) {
        super(blockstate, maxGenRangeHeight, minGenRangeHeight, maxPerChunk, minPerChunk, genDense);
        this.veinType = vein;
        this.surfaceList = list;
    }

    @Override
    public void doOreGen(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        if (chunkscan.caveset.size() > 0) {
            int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg);
            int blockReqs = this.blocksReq();
            while (blocksPerChunk > blockReqs || blocksPerChunk > 0 && random.nextInt(blockReqs) < blocksPerChunk) {
                surface gen = this.surfaceList.get(random.nextInt(this.surfaceList.size()));
                BlockPos pos = null;
                switch (gen) {
                    case ceiling: {
                        pos = chunkscan.caveset.get(random.nextInt(chunkscan.caveset.size())).getRandomPosition(random).getCeilingPos();
                        break;
                    }
                    case floor: {
                        pos = chunkscan.caveset.get(random.nextInt(chunkscan.caveset.size())).getRandomPosition(random).getFloorPos();
                        break;
                    }
                    case wall: {
                        ArrayList<BlockPos> wall = chunkscan.caveset.get((int)random.nextInt((int)chunkscan.caveset.size())).wall;
                        if (wall.size() <= 0) break;
                        pos = wall.get(random.nextInt(wall.size()));
                        break;
                    }
                }
                if (pos == null) continue;
                blocksPerChunk -= this.veinType.genVein(world, map, random, chunkscan, pos);
            }
        }
    }

    @Override
    public int genVein(World world, ChunkDividedOreMap map, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        return 0;
    }

    @Override
    public int blocksReq() {
        return this.veinType.blocksReq();
    }

    public static enum surface {
        floor,
        wall,
        ceiling;

    }
}

