/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.BiomeDictionary;
import wtf.Core;
import wtf.blocks.BlockDenseOre;
import wtf.blocks.BlockDenseOreFalling;
import wtf.blocks.redstone.DenseRedstoneOre;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.ores.OreGenAbstract;
import wtf.ores.OreGenerator;
import wtf.ores.oregenerators.OreGenCaveFloor;
import wtf.ores.oregenerators.OreGenCloud;
import wtf.ores.oregenerators.OreGenCluster;
import wtf.ores.oregenerators.OreGenSingle;
import wtf.ores.oregenerators.OreGenUnderWater;
import wtf.ores.oregenerators.OreGenVanilla;
import wtf.ores.oregenerators.OreGenVein;
import wtf.utilities.wrappers.StoneAndOre;

public class ParseOre {
    public static void parse(String orestring) throws Exception {
        GENTYPE gentype;
        orestring = orestring.replaceAll("\\s", "");
        Core.coreLog.info("WTF-ores: loading from " + orestring);
        String[] stringArray = orestring.split(",");
        String[] genTypeArray = stringArray[0].split("@");
        try {
            gentype = GENTYPE.valueOf(genTypeArray[0].toLowerCase());
        }
        catch (IllegalArgumentException e) {
            GENTYPE[] types = GENTYPE.values();
            String gentypestring = "";
            for (GENTYPE type : types) {
                gentypestring = gentypestring + type.toString() + ", ";
            }
            throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** " + stringArray[0] + " is not a recognised generation type.  Accepted generation types are: " + gentypestring);
        }
        IBlockState blockstate = ParseOre.getBlockState(stringArray[1]);
        if (!stringArray[1].contains(":")) {
            throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " expected a block argument, got this instead " + stringArray[1] + " The second argument of each string MUST be the block and metadata, in the format modID:block@metadata");
        }
        String oreName = stringArray[1].split(":")[1].split("@")[0] + Integer.parseInt(stringArray[1].split(":")[1].split("@")[1]);
        if (blockstate == null) {
            throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** cound not find block for " + stringArray[1] + " Turn on the block name getter in the core config, and place the block whose name you want in the world to get the blocks registry name");
        }
        float spawnmin = -1.0f;
        float spawnmax = -1.0f;
        int minperchunk = -1;
        int maxperchunk = -1;
        int thickness = -1;
        int length = -1;
        int width = -1;
        int size = -1;
        ArrayList<OreGenCaveFloor.surface> surfacelist = new ArrayList<OreGenCaveFloor.surface>();
        ArrayList<BiomeDictionary.Type> reqBiomeTypes = new ArrayList<BiomeDictionary.Type>();
        boolean denseOres = false;
        ArrayList<IBlockState> stones = new ArrayList<IBlockState>();
        float pitch = -99.0f;
        HashSet<Integer> dimensions = new HashSet<Integer>();
        HashMap<BiomeDictionary.Type, Float> biomeMap = new HashMap<BiomeDictionary.Type, Float>();
        float density = 1.0f;
        block31: for (int loop = 2; loop < stringArray.length; ++loop) {
            ARGUMENT argument;
            String[] subStringArray = stringArray[loop].toLowerCase().split("=");
            String[] uncleaned = stringArray[loop].split("=");
            try {
                argument = ARGUMENT.valueOf(subStringArray[0]);
            }
            catch (IllegalArgumentException e) {
                ARGUMENT[] aRGUMENTArray = ARGUMENT.values();
                String argstring = "";
                for (ARGUMENT type : aRGUMENTArray) {
                    argstring = argstring + type.toString() + ", ";
                }
                throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** " + subStringArray[0] + " is not a recognised argument.  Recognised arguments are : " + argstring);
            }
            switch (argument) {
                case oreperchunk: {
                    String[] perchunkArray = subStringArray[1].split("&");
                    if (perchunkArray.length != 2) {
                        throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** OrePerChunk argument should only have 2 variable, and as written it has " + perchunkArray.length);
                    }
                    minperchunk = Integer.parseInt(perchunkArray[0]);
                    maxperchunk = Integer.parseInt(perchunkArray[1]);
                    continue block31;
                }
                case pitch: {
                    pitch = Float.parseFloat(subStringArray[1]);
                    continue block31;
                }
                case size: {
                    size = Integer.parseInt(subStringArray[1]);
                    continue block31;
                }
                case genheightpercentsurface: {
                    String[] stringArray2 = subStringArray[1].split("&");
                    if (stringArray2.length != 2) {
                        throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** GenHeightPercentSurface argument should only have 2 variable, and as written it has " + stringArray2.length);
                    }
                    spawnmin = (float)Integer.parseInt(stringArray2[0]) / 100.0f;
                    spawnmax = (float)Integer.parseInt(stringArray2[1]) / 100.0f;
                    continue block31;
                }
                case veindimensions: {
                    String[] veinArray = subStringArray[1].split("&");
                    if (veinArray.length != 3) {
                        throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** VeinDimensions argument should only have 3 variable, and as written it has " + veinArray.length);
                    }
                    length = Integer.parseInt(veinArray[0]);
                    width = Integer.parseInt(veinArray[1]);
                    thickness = Integer.parseInt(veinArray[2]);
                    continue block31;
                }
                case densitypercent: {
                    density = (float)Integer.parseInt(subStringArray[1]) / 100.0f;
                    if (!(density < 0.0f) && !(density > 1.0f)) continue block31;
                    throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** DensityPercent cannot be set to less than 1, or more than 100, currently set to : " + subStringArray[1]);
                }
                case dimension: {
                    dimensions.add(Integer.parseInt(subStringArray[1]));
                    continue block31;
                }
                case genpercentinbiometype: {
                    BiomeDictionary.Type biometype;
                    String[] biomeArray = subStringArray[1].split("@");
                    try {
                        biometype = BiomeDictionary.Type.valueOf((String)biomeArray[0].toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        BiomeDictionary.Type[] types = BiomeDictionary.Type.values();
                        String string = "";
                        for (String string2 : types) {
                            string = string + string2.toString() + ", ";
                        }
                        throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** Unrecognised Forge BiomeDictionary BiomeType, the available biome types are : " + string);
                    }
                    float f = (float)Integer.parseInt(biomeArray[1]) / 100.0f;
                    biomeMap.put(biometype, Float.valueOf(f));
                    continue block31;
                }
                case stone: {
                    IBlockState stoneBlockState = ParseOre.getBlockState(uncleaned[1]);
                    if (blockstate == null) {
                        throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** cound not find block for " + stringArray[1] + " int the stone section of the config.  Turn on the block name getter in the core config, and place the block whose name you want in the world to get the blocks registry name");
                    }
                    stones.add(stoneBlockState);
                    continue block31;
                }
                case denseore: {
                    denseOres = Boolean.parseBoolean(subStringArray[1]);
                    continue block31;
                }
                case surfaces: {
                    String[] surfacestrings;
                    for (String string : surfacestrings = subStringArray[1].split("&")) {
                        try {
                            surfacelist.add(OreGenCaveFloor.surface.valueOf(string.toLowerCase()));
                        }
                        catch (IllegalArgumentException e) {
                            OreGenCaveFloor.surface[] types = OreGenCaveFloor.surface.values();
                            String gentypestring = "";
                            for (OreGenCaveFloor.surface type : types) {
                                gentypestring = gentypestring + type.toString() + ", ";
                            }
                            throw new Exception("Ore Config Parsing Exception while trying to parse  : " + orestring + " ***** " + stringArray[0] + " is not a recognised surface type.  Accepted surface types are: " + gentypestring);
                        }
                    }
                    continue block31;
                }
                case reqbiometype: {
                    BiomeDictionary.Type biometype;
                    try {
                        biometype = BiomeDictionary.Type.valueOf((String)subStringArray[1].toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        BiomeDictionary.Type[] types = BiomeDictionary.Type.values();
                        String string = "";
                        for (BiomeDictionary.Type type : types) {
                            string = string + type.toString() + ", ";
                        }
                        throw new Exception("Ore Config Parsing Exception while trying to parse reqBiomeType : " + orestring + " ***** Unrecognised Forge BiomeDictionary BiomeType, the available biome types are : " + string);
                    }
                    reqBiomeTypes.add(biometype);
                    continue block31;
                }
                default: {
                    ARGUMENT[] types = ARGUMENT.values();
                    String string = "";
                    for (ARGUMENT type : types) {
                        string = string + type.toString() + ", ";
                    }
                    throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** Unrecognised argument.  Valid arguments are : " + string);
                }
            }
        }
        if (spawnmin == -1.0f) {
            throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** missing GenHeightPercentSurface argument");
        }
        if (minperchunk == -1) {
            throw new Exception("Ore Config Parsing Exception while trying to parse : " + orestring + " ***** missing OrePerChunk argument");
        }
        OreGenAbstract oregenerator = null;
        if (genTypeArray.length > 1) {
            GENTYPE secondaryGenType = null;
            try {
                secondaryGenType = GENTYPE.valueOf(genTypeArray[1].toLowerCase());
            }
            catch (IllegalArgumentException e) {
                GENTYPE[] types = GENTYPE.values();
                String gentypestring = "";
                for (GENTYPE type : types) {
                    gentypestring = gentypestring + type.toString() + ", ";
                }
                throw new Exception("Ore Config Parsing Exception while trying to parse secondary generation type for : " + orestring + " ***** " + stringArray[0] + " is not a recognised generation type.  Accepted generation types are: " + gentypestring);
            }
            OreGenAbstract secondaryGen = null;
            switch (gentype) {
                case cave: {
                    if (surfacelist.size() == 0) {
                        throw new Exception("Ore Config Parsing Exception while trying to parse string for " + blockstate.func_177230_c().func_149732_F() + "No surfaces have been set- use the surface=ceiling & wall & floor argument to set a surface of the cave to generate on");
                    }
                    secondaryGen = ParseOre.getGenerator(secondaryGenType, blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, length, width, thickness, pitch, denseOres, size);
                    oregenerator = new OreGenCaveFloor(secondaryGen, blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, denseOres, surfacelist);
                    break;
                }
                case underwater: {
                    secondaryGen = ParseOre.getGenerator(secondaryGenType, blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, length, width, thickness, pitch, denseOres, size);
                    oregenerator = new OreGenUnderWater(secondaryGen, blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, denseOres);
                }
            }
        } else {
            oregenerator = ParseOre.getGenerator(gentype, blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, length, width, thickness, pitch, denseOres, size);
        }
        if (stones.size() == 0) {
            stones.add(Blocks.field_150348_b.func_176223_P());
        }
        for (IBlockState stone : stones) {
            if (denseOres) {
                Block block = null;
                String stoneName = stone.func_177230_c().getRegistryName().toString().split(":")[1] + stone.func_177230_c().func_176201_c(stone);
                String string = stoneName + oreName;
                if (blockstate.func_177230_c() != Blocks.field_150450_ax) {
                    block = stone.func_177230_c() instanceof BlockFalling ? WTFBlocks.registerBlock((Block)new BlockDenseOreFalling(stone, blockstate), "dense_" + string) : WTFBlocks.registerBlock(new BlockDenseOre(stone, blockstate), "dense_" + string);
                } else {
                    DenseRedstoneOre.denseRedstone_off = block = WTFBlocks.registerBlock(new DenseRedstoneOre(false), "dense_" + string);
                    DenseRedstoneOre.denseRedstone_on = WTFBlocks.registerBlock(new DenseRedstoneOre(true), "dense_" + string + "_on");
                }
                BlockSets.stoneAndOre.put(new StoneAndOre(stone, blockstate), block.func_176223_P());
                continue;
            }
            BlockSets.stoneAndOre.put(new StoneAndOre(stone, blockstate), blockstate);
        }
        oregenerator.biomeModifier = biomeMap;
        oregenerator.setVeinDensity(density);
        if (!dimensions.isEmpty()) {
            oregenerator.dimension = dimensions;
        }
        oregenerator.reqBiomeTypes.addAll(reqBiomeTypes);
        OreGenerator.oreGenRegister.add(oregenerator);
    }

    public static IBlockState getBlockState(String string) {
        String[] stringArray = string.split("@");
        Block block = Block.func_149684_b((String)stringArray[0]);
        return block == null ? null : block.func_176203_a(Integer.parseInt(stringArray[1]));
    }

    public static OreGenAbstract getGenerator(GENTYPE gentype, IBlockState blockstate, float spawnmax, float spawnmin, int maxperchunk, int minperchunk, int length, int width, int thickness, float pitch, boolean denseOres, int size) throws Exception {
        switch (gentype) {
            case cloud: {
                if (size == -1) {
                    throw new Exception("Ore Config Parsing Exception while trying to parse string for " + blockstate.func_177230_c().func_149732_F() + "missing Size argument");
                }
                return new OreGenCloud(blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, size, denseOres);
            }
            case cluster: {
                return new OreGenCluster(blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, denseOres);
            }
            case single: {
                return new OreGenSingle(blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, denseOres);
            }
            case vanilla: {
                if (size == -1) {
                    throw new Exception("Ore Config Parsing Exception while trying to parse string for " + blockstate.func_177230_c().func_149732_F() + "missing Size argument");
                }
                return new OreGenVanilla(blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, size, denseOres);
            }
            case vein: {
                if (length == -1) {
                    throw new Exception("Ore Config Parsing Exception while trying to parse string for " + blockstate.func_177230_c().func_149732_F() + "missing VeinDimensions argument");
                }
                if (pitch == -99.0f) {
                    throw new Exception("Ore Config Parsing Exception while trying to parse string for " + blockstate.func_177230_c().func_149732_F() + "missing Pitch argument");
                }
                return new OreGenVein(blockstate, spawnmax, spawnmin, maxperchunk, minperchunk, length, width, thickness, pitch, denseOres);
            }
        }
        return null;
    }

    public static enum ARGUMENT {
        oreperchunk,
        genheightpercentsurface,
        size,
        veindimensions,
        pitch,
        densitypercent,
        dimension,
        genpercentinbiometype,
        stone,
        denseore,
        surfaces,
        reqbiometype;

    }

    public static enum GENTYPE {
        vanilla,
        vein,
        cloud,
        cluster,
        single,
        cave,
        underwater;

    }
}

