/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import wtf.ores.ChunkDividedOreMap;
import wtf.ores.config.WTFOreConfig;
import wtf.utilities.Simplex;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;

public abstract class OreGenAbstract {
    protected final IBlockState oreBlock;
    public HashMap<BiomeDictionary.Type, Float> biomeModifier = new HashMap();
    public HashSet<Integer> dimension = new HashSet();
    protected final float maxGenRangeHeight;
    protected final float minGenRangeHeight;
    protected final int maxPerChunk;
    protected final int minPerChunk;
    protected Float veinDensity = Float.valueOf(1.0f);
    private Simplex simplex = null;
    private int seed = 0;
    public final boolean genDenseOres;
    public final ArrayList<BiomeDictionary.Type> reqBiomeTypes = new ArrayList();

    public OreGenAbstract(IBlockState blockstate, float maxGenRangeHeight, float minGenRangeHeight, int maxPerChunk, int minPerChunk, boolean denseGen) {
        this.oreBlock = blockstate;
        this.maxGenRangeHeight = maxGenRangeHeight;
        this.minGenRangeHeight = minGenRangeHeight;
        this.maxPerChunk = maxPerChunk;
        this.minPerChunk = minPerChunk;
        this.dimension.add(0);
        this.genDenseOres = denseGen;
    }

    public final void generate(World world, ChunkDividedOreMap map, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        if (this.dimension.contains(world.field_73011_w.getDimension())) {
            Biome biome = world.getBiomeForCoordsBody(new BlockPos(coords.getWorldX(), 100, coords.getWorldZ()));
            if (this.reqBiomeTypes.size() > 0) {
                for (BiomeDictionary.Type type : this.reqBiomeTypes) {
                    if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                    return;
                }
            }
            this.doOreGen(world, map, random, coords, chunkscan);
        }
    }

    public abstract void doOreGen(World var1, ChunkDividedOreMap var2, Random var3, ChunkCoords var4, ChunkScan var5) throws Exception;

    public abstract int genVein(World var1, ChunkDividedOreMap var2, Random var3, ChunkScan var4, BlockPos var5) throws Exception;

    public abstract int blocksReq();

    protected int getBlocksPerChunk(World world, ChunkCoords coords, Random random, double surfaceAvg) {
        BiomeDictionary.Type[] biomeTypes;
        int genNum = WTFOreConfig.simplexGen ? (int)this.getSimplexOres(world, coords.getWorldX(), coords.getWorldZ()) : (int)random.nextFloat() * (this.maxPerChunk - this.minPerChunk) + this.minPerChunk;
        for (BiomeDictionary.Type biome : biomeTypes = BiomeDictionary.getTypesForBiome((Biome)world.func_180494_b(new BlockPos((double)(coords.getWorldX() + 8), surfaceAvg, (double)(coords.getWorldZ() + 8))))) {
            if (!this.biomeModifier.containsKey(biome)) continue;
            genNum = (int)((float)genNum + (float)(this.minPerChunk + (this.maxPerChunk - this.minPerChunk) / 2) * this.biomeModifier.get(biome).floatValue());
        }
        return (int)((float)genNum * (float)surfaceAvg / (float)world.func_181545_F());
    }

    public int getGenStartHeight(double surfaceAvg, Random random) {
        int maxHeight = MathHelper.func_76141_d((float)((float)((double)this.maxGenRangeHeight * surfaceAvg)));
        int minHeight = MathHelper.func_76141_d((float)((float)((double)this.minGenRangeHeight * surfaceAvg)));
        return random.nextInt(maxHeight - minHeight) + minHeight;
    }

    public int getDensityToSet(Random random, double d) {
        double density = d * (double)random.nextInt(8) / (double)this.veinDensity.floatValue();
        if (density < 1.0) {
            return 0;
        }
        if (density > 2.0) {
            return 2;
        }
        return 1;
    }

    public OreGenAbstract setVeinDensity(float density) {
        this.veinDensity = Float.valueOf(density);
        return this;
    }

    public double getSimplexOres(World world, double x, double z) {
        double range = (this.maxPerChunk - this.minPerChunk) / 2;
        if ((long)this.seed != world.func_72905_C()) {
            this.seed = (int)(world.func_72905_C() * (long)this.oreBlock.hashCode());
            this.simplex = new Simplex(this.seed);
        }
        return this.simplex.noise(x / 8.0, z / 8.0) * range + range + (double)this.minPerChunk;
    }
}

