/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import wtf.blocks.BlockDenseOre;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.OrePos;
import wtf.utilities.wrappers.StoneAndOre;

public class ChunkDividedOreMap {
    private final HashMap<ChunkCoords, HashMap<OrePos, IBlockState>> hashmap = new HashMap();
    private final World world;

    public ChunkDividedOreMap(World world, ChunkCoords coords) {
        this.hashmap.put(coords, new HashMap());
        this.world = world;
    }

    public void put(OrePos pos, IBlockState state) {
        ChunkCoords coords = new ChunkCoords(pos);
        HashMap<OrePos, IBlockState> submap = this.hashmap.get(coords);
        if (submap != null) {
            submap.put(pos, state);
        } else {
            HashMap<OrePos, IBlockState> newMap = new HashMap<OrePos, IBlockState>();
            newMap.put(pos, state);
            this.hashmap.put(coords, newMap);
        }
    }

    public void putAll(HashMap<OrePos, IBlockState> mapIn) {
        for (Map.Entry<OrePos, IBlockState> entry : mapIn.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void setBlockSet() {
        for (Map.Entry<ChunkCoords, HashMap<OrePos, IBlockState>> subMap : this.hashmap.entrySet()) {
            Chunk chunk = subMap.getKey().getChunk(this.world);
            for (Map.Entry<OrePos, IBlockState> entry : subMap.getValue().entrySet()) {
                IBlockState state;
                StoneAndOre stoneandore;
                IBlockState oreType;
                if (entry.getKey().func_177956_o() <= 1 || entry.getKey().func_177956_o() >= this.world.func_72800_K()) continue;
                BlockPos pos = entry.getKey();
                ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[pos.func_177956_o() >> 4];
                if (extendedblockstorage != Chunk.field_186036_a) {
                    oreType = entry.getValue();
                    stoneandore = new StoneAndOre(extendedblockstorage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF), oreType);
                    state = BlockSets.stoneAndOre.get(stoneandore);
                    if (state == null) continue;
                    if (state.func_177230_c() instanceof BlockDenseOre) {
                        state = state.func_177226_a((IProperty)BlockDenseOre.DENSITY, (Comparable)Integer.valueOf(entry.getKey().density));
                    }
                    if (state == null) continue;
                    extendedblockstorage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
                    continue;
                }
                oreType = entry.getValue();
                stoneandore = new StoneAndOre(chunk.func_177435_g(pos), oreType);
                state = BlockSets.stoneAndOre.get(stoneandore);
                if (state == null) continue;
                if (state.func_177230_c() instanceof BlockDenseOre) {
                    state = state.func_177226_a((IProperty)BlockDenseOre.DENSITY, (Comparable)Integer.valueOf(entry.getKey().density));
                }
                if (state == null) continue;
                chunk.func_177436_a(pos, state);
            }
        }
    }
}

