/*
 * Decompiled with CFR 0.152.
 */
package wtf.gameplay;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.config.GameplayConfig;
import wtf.gameplay.GravityMethods;

public class WTFSlidingBlock
extends EntityFallingBlock {
    private IBlockState fallTile;
    private int fallHurtMax = 40;
    private float fallHurtAmount = 2.0f;
    private final BlockPos origin;
    private boolean fallen = false;
    private final boolean sliding;

    public WTFSlidingBlock(World worldIn, BlockPos pos, BlockPos targetpos, IBlockState state, boolean sliding) {
        super(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state);
        this.fallTile = state;
        this.fallen = !sliding;
        this.sliding = sliding;
        this.origin = pos;
        double motx = pos.func_177958_n() - targetpos.func_177958_n();
        double motz = pos.func_177952_p() - targetpos.func_177952_p();
        this.func_70024_g(0.1 * motx, -0.1, 0.1 * motz);
        worldIn.func_72838_d((Entity)this);
    }

    public WTFSlidingBlock(World worldIn, BlockPos pos) {
        super(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
        this.fallTile = worldIn.func_180495_p(pos);
        this.fallen = true;
        this.sliding = false;
        this.origin = pos;
        this.func_70024_g(0.0, -0.1, 0.0);
        worldIn.func_72838_d((Entity)this);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        Block block = this.fallTile.func_177230_c();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_145812_b++ == 0) {
            BlockPos blockpos = new BlockPos((Entity)this);
            if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == block) {
                this.field_70170_p.func_175698_g(blockpos);
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
        }
        BlockPos blockpos1 = new BlockPos((Entity)this);
        if (!this.fallen && this.field_70163_u < (double)this.origin.func_177956_o()) {
            this.fallen = true;
            GravityMethods.checkPos(this.field_70170_p, this.origin.func_177977_b());
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.fallen && this.sliding) {
            this.field_70159_w *= 0.2;
            this.field_70179_y *= 0.2;
        }
        if (this.field_70122_E && this.fallen) {
            if (BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)))) {
                this.field_70122_E = false;
                return;
            }
            this.setBlock();
        } else if (this.field_145812_b > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.field_145812_b > 600) {
            if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.fallTile)), 0.0f);
            }
            this.func_70106_y();
        } else if (Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y) + Math.abs(this.field_70181_x) < 0.1) {
            this.setBlock();
        }
    }

    private void setBlock() {
        BlockPos blockpos1;
        Block block = this.fallTile.func_177230_c();
        if (this.field_70170_p.func_175716_a(block, blockpos1 = new BlockPos((Entity)this), true, EnumFacing.UP, (Entity)null, (ItemStack)null) && !BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(blockpos1.func_177977_b())) && this.field_70170_p.func_180501_a(blockpos1, this.fallTile, 3)) {
            TileEntity tileentity;
            if (block instanceof BlockFalling) {
                ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockpos1);
            }
            if (this.field_145810_d != null && block instanceof ITileEntityProvider && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                for (String s : this.field_145810_d.func_150296_c()) {
                    NBTBase nbtbase = this.field_145810_d.func_74781_a(s);
                    if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                    nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                }
                tileentity.func_145839_a(nbttagcompound);
                tileentity.func_70296_d();
            }
        } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(this.fallTile)), 0.0f);
        }
        this.field_70170_p.func_72900_e((Entity)this);
        GravityMethods.checkPos(this.field_70170_p, blockpos1);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        Block block = this.fallTile.func_177230_c();
        if (GameplayConfig.fallingBlocksDamage && (i = MathHelper.func_76123_f((float)(distance - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            boolean flag = block == Blocks.field_150467_bQ;
            DamageSource damagesource = flag ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                entity.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * this.fallHurtAmount)), this.fallHurtMax));
            }
            if (flag && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                int j = (Integer)this.fallTile.func_177229_b((IProperty)BlockAnvil.field_176505_b);
                if (++j <= 2) {
                    this.fallTile = this.fallTile.func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(j));
                }
            }
        }
    }
}

