/*
 * Decompiled with CFR 0.152.
 */
package wtf.gameplay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.blocks.AnimatedBlock;
import wtf.blocks.BlockDenseOre;
import wtf.gameplay.GravityMethods;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.Vec;

public class StoneFractureMethods {
    static Random random = new Random();
    static int coal = Blocks.field_150365_q.getHarvestLevel(Blocks.field_150365_q.func_176223_P());
    static int iron = Blocks.field_150366_p.getHarvestLevel(Blocks.field_150366_p.func_176223_P());
    static float pi = (float)Math.PI;
    static final int crackedHash = WTFBlocks.crackedStone.hashCode();

    public static void tryFrac(World world, BlockPos pos, Block block, int tool) {
        if (block instanceof BlockDenseOre) {
            StoneFractureMethods.denseFrac(world, pos, tool);
        } else {
            StoneFractureMethods.frac(world, pos, tool);
        }
    }

    public static void frac(World world, BlockPos pos, int tool) {
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        hashset.add(pos.func_177984_a());
        hashset.add(pos.func_177977_b());
        hashset.add(pos.func_177974_f());
        hashset.add(pos.func_177976_e());
        hashset.add(pos.func_177978_c());
        hashset.add(pos.func_177968_d());
        StoneFractureMethods.FracIterator(world, hashset);
    }

    public static void denseFrac(World world, BlockPos pos, int tool) {
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        int blockLevel = world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos));
        if (blockLevel <= coal) {
            hashset.addAll(StoneFractureMethods.fracLow(world, pos, (tool + 1) * 5));
        } else if (blockLevel <= iron) {
            hashset.addAll(StoneFractureMethods.fracStandard(world, pos, (tool + 1) * 4));
        } else {
            hashset.addAll(StoneFractureMethods.fracCrack(world, pos, (tool + 1) * 4));
        }
        StoneFractureMethods.FracIterator(world, hashset);
    }

    public static void hammerFrac(World world, BlockPos pos, int tool) {
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        int blockLevel = world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos));
        hashset.addAll(StoneFractureMethods.fracCrack(world, pos, (tool + 1) * 4));
        StoneFractureMethods.FracIterator(world, hashset);
    }

    public static ArrayList<BlockPos> getAdjPos(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int xloop = -1; xloop < 2; ++xloop) {
            for (int yloop = -1; yloop < 2; ++yloop) {
                for (int zloop = -1; zloop < 2; ++zloop) {
                    if (xloop == 0 || yloop == 0 || zloop == 0) continue;
                    list.add(new BlockPos(pos.func_177958_n() + xloop, pos.func_177956_o() + yloop, pos.func_177952_p() + zloop));
                }
            }
        }
        return list;
    }

    public static HashSet<BlockPos> fracLow(World world, BlockPos pos, int n) {
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        ArrayList<BlockPos> adjPos = StoneFractureMethods.getAdjPos(pos);
        for (int loop = 0; loop < n; ++loop) {
            BlockPos randPos = adjPos.get(random.nextInt(adjPos.size()));
            if (!BlockSets.hasCobble(world.func_180495_p(randPos))) continue;
            hashset.add(randPos);
        }
        return hashset;
    }

    public static HashSet<BlockPos> fracStandard(World world, BlockPos pos, int n) {
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        for (int loop = 0; loop < n; ++loop) {
            Vec frac = new Vec(pos, random);
            BlockPos fracPos = frac.next();
            while (BlockSets.isFractured(world.func_180495_p(fracPos)) || hashset.contains(fracPos)) {
                fracPos = frac.next();
            }
            if (!BlockSets.hasCobble(world.func_180495_p(fracPos))) continue;
            hashset.add(fracPos);
        }
        return hashset;
    }

    public static HashSet<BlockPos> fracCrack(World world, BlockPos pos, int n) {
        HashSet<BlockPos> hashset = new HashSet<BlockPos>();
        Random posRandom = new Random(pos.hashCode());
        for (int loop = 0; loop < n; ++loop) {
            Vec fracVec = new Vec(pos, posRandom);
            BlockPos fracPos = fracVec.next();
            while (BlockSets.isFractured(world.func_180495_p(fracPos)) || hashset.contains(fracPos)) {
                fracPos = fracVec.next();
            }
            if (!BlockSets.hasCobble(world.func_180495_p(fracPos))) continue;
            hashset.add(fracPos);
            for (int loop2 = random.nextInt(3); loop2 > 0; --loop2) {
                while ((BlockSets.isFractured(world.func_180495_p(fracPos)) || hashset.contains(fracPos)) && BlockSets.hasCobble(world.func_180495_p(fracPos = fracVec.next()))) {
                    hashset.add(fracPos);
                }
            }
        }
        return hashset;
    }

    public static void FracIterator(World world, HashSet<BlockPos> hashset) {
        HashSet<BlockPos> hashset2 = new HashSet<BlockPos>();
        for (BlockPos pos : hashset) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c().hashCode() == crackedHash) {
                hashset2.add(pos.func_177984_a());
                hashset2.add(pos.func_177977_b());
                hashset2.add(pos.func_177974_f());
                hashset2.add(pos.func_177976_e());
                hashset2.add(pos.func_177978_c());
                hashset2.add(pos.func_177968_d());
            }
            StoneFractureMethods.fracStone(world, pos, state);
        }
        if (hashset2.size() > 0) {
            StoneFractureMethods.FracIterator(world, hashset2);
        }
    }

    public static boolean fracStone(World world, BlockPos pos, IBlockState state) {
        IBlockState stateToSet = BlockSets.getTransformedState(state, BlockSets.Modifier.COBBLE);
        if (stateToSet != null) {
            world.func_175656_a(pos, stateToSet);
            GravityMethods.dropBlock(world, pos, false);
            return true;
        }
        if (world.func_180495_p(pos) instanceof AnimatedBlock && state.func_177229_b(AnimatedBlock.TYPE) == AnimatedBlock.ANIMTYPE.LAVA_CRUST) {
            world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        }
        return false;
    }
}

