/*
 * Decompiled with CFR 0.152.
 */
package wtf.gameplay;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wtf.blocks.AbstractBlockDerivative;
import wtf.config.CoreConfig;
import wtf.config.GameplayConfig;
import wtf.gameplay.CustomExplosion;
import wtf.gameplay.GravityMethods;
import wtf.gameplay.StoneFractureMethods;
import wtf.init.BlockSets;

public class GamePlayEventListener {
    Random random = new Random();

    @SubscribeEvent
    public void StoneBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block = event.getState().func_177230_c();
        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
            if (GamePlayEventListener.isHammer(event.getEntityPlayer().func_184614_ca())) {
                if (BlockSets.blockMiningSpeed.containsKey(block)) {
                    event.setNewSpeed(BlockSets.blockMiningSpeed.get(block).floatValue() * event.getOriginalSpeed());
                }
            } else if (BlockSets.blockMiningSpeed.containsKey(block)) {
                event.setNewSpeed(BlockSets.blockMiningSpeed.get(block).floatValue() * event.getOriginalSpeed());
            } else if (block instanceof AbstractBlockDerivative && !block.canHarvestBlock((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos(), event.getEntityPlayer())) {
                event.setNewSpeed(0.2f * event.getOriginalSpeed());
            }
        }
    }

    @SubscribeEvent
    public void PlayerPlaceBlock(BlockEvent.PlaceEvent event) {
        Block block;
        if (CoreConfig.enableNameGetter) {
            event.getPlayer().func_146105_b((ITextComponent)new TextComponentString("The block name is : " + event.getState().func_177230_c().getRegistryName()));
            event.getPlayer().func_146105_b((ITextComponent)new TextComponentString("The block metadata is : " + event.getState().func_177230_c().func_176201_c(event.getState())));
        }
        if (BlockSets.fallingBlocks.containsKey(block = event.getState().func_177230_c())) {
            GravityMethods.checkPos(event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d && event.getEntityPlayer().func_184614_ca() != null && BlockSets.oreAndFractures.contains(block = Block.func_149634_a((Item)event.getEntityPlayer().func_184614_ca().func_77973_b()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void BlockBreakEvent(BlockEvent.BreakEvent event) {
        ItemStack tool = event.getPlayer().func_184614_ca();
        int toolLevel = tool == null ? 0 : tool.func_77973_b().getHarvestLevel(tool, "pickaxe");
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (!event.getPlayer().field_71075_bZ.field_75098_d) {
            if (BlockSets.hasCobble(event.getState()) && GameplayConfig.stoneFracturesBeforeBreaking) {
                if (GamePlayEventListener.isHammer(event.getPlayer().func_184614_ca()) && GameplayConfig.modifyHammer) {
                    event.setCanceled(true);
                    StoneFractureMethods.fracStone(event.getWorld(), event.getPos(), event.getState());
                    StoneFractureMethods.hammerFrac(event.getWorld(), event.getPos(), toolLevel);
                    event.setCanceled(true);
                    if (tool != null) {
                        tool.func_96631_a(1, this.random);
                        event.getPlayer().func_71029_a(StatList.func_188055_a((Block)block));
                        event.getPlayer().func_71020_j(0.025f);
                    }
                } else if (StoneFractureMethods.fracStone(event.getWorld(), event.getPos(), event.getState())) {
                    event.setCanceled(true);
                    if (tool != null) {
                        tool.func_96631_a(1, this.random);
                        event.getPlayer().func_71029_a(StatList.func_188055_a((Block)block));
                        event.getPlayer().func_71020_j(0.025f);
                    }
                }
            } else if (BlockSets.oreAndFractures.contains(block) && GameplayConfig.oreFractures) {
                StoneFractureMethods.tryFrac(event.getWorld(), event.getPos(), block, toolLevel);
            }
            GravityMethods.checkPos(event.getWorld(), event.getPos().func_177984_a());
        }
    }

    @SubscribeEvent
    public void BlockHarvestEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() instanceof BlockLeaves && this.random.nextInt(100) < GameplayConfig.stickDrop) {
            event.getDrops().add(new ItemStack(Items.field_151055_y, 1));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityChicken chicken;
        if (GameplayConfig.featherDrop != 0 && !event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityChicken && !(chicken = (EntityChicken)event.getEntity()).func_70631_g_() && this.random.nextInt(GameplayConfig.featherDrop) == 1) {
            chicken.func_145779_a(Items.field_151008_G, 1);
        }
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Start event) {
        if (GameplayConfig.customExplosion) {
            Explosion explosion = event.getExplosion();
            float size = ((Float)ObfuscationReflectionHelper.getPrivateValue(Explosion.class, (Object)explosion, (int)8)).floatValue();
            new CustomExplosion((Entity)explosion.func_94613_c(), event.getWorld(), explosion.getPosition(), size);
            event.setCanceled(true);
        }
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b().func_77653_i(stack).contains("ammer");
    }
}

