/*
 * Decompiled with CFR 0.152.
 */
package wtf.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import wtf.crafting.RecipeParser;
import wtf.crafting.RecipeWrapper;

public class CraftingLogic {
    public static ArrayList<RecipeWrapper> getCraftableStack(EntityPlayer player) {
        HashMap<Integer, Integer> inventoryHashMap = new HashMap<Integer, Integer>();
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null) continue;
            inventoryHashMap.put(CraftingLogic.itemNum(stack), stack.field_77994_a);
        }
        ArrayList<RecipeWrapper> craftableRecipes = new ArrayList<RecipeWrapper>();
        for (RecipeWrapper recipe : RecipeParser.parsedRecipes) {
            if (!CraftingLogic.canCraft(recipe, inventoryHashMap)) continue;
            craftableRecipes.add(recipe);
        }
        return craftableRecipes;
    }

    public static boolean canCraft(RecipeWrapper recipe, HashMap<Integer, Integer> inventoryHashMap) {
        for (ArrayList<ItemStack> subList : recipe.getIngrediants()) {
            if (subList.size() <= 0 || CraftingLogic.hasIngrediant(inventoryHashMap, subList)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasIngrediant(HashMap<Integer, Integer> inventoryHashMap, ArrayList<ItemStack> subList) {
        for (ItemStack ingrediant : subList) {
            if (ingrediant == null) {
                return true;
            }
            if (!inventoryHashMap.containsKey(CraftingLogic.itemNum(ingrediant))) continue;
            return true;
        }
        return false;
    }

    private static int itemNum(ItemStack stack) {
        return Item.func_150891_b((Item)stack.func_77973_b()) * 16 + stack.func_77952_i();
    }
}

