/*
 * Decompiled with CFR 0.152.
 */
package wtf.core.gameplay;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.core.config.GameplayConfig;
import wtf.core.init.BlockSets;

public class GravityMethods {
    public static void dropBlock(World world, int x, int y, int z, Boolean checkStability) {
        BlockPos blockpos = new BlockPos(x, y, z);
        if (BlockSets.fallingBlocks.containsKey(world.func_180495_p(blockpos).func_177230_c())) {
            for (int xloop = -2; xloop < 3; ++xloop) {
                for (int yloop = -1; yloop < 1; ++yloop) {
                    for (int zloop = -2; zloop < 3; ++zloop) {
                        if (!(world.func_180495_p(new BlockPos(x + xloop, y + yloop, z + zloop)).func_177230_c() instanceof BlockFence)) continue;
                        return;
                    }
                }
            }
            EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), world.func_180495_p(blockpos));
            entityfallingblock.func_145806_a(GameplayConfig.fallingBlocksDamage);
            if (world.func_72838_d((Entity)entityfallingblock)) {
                // empty if block
            }
            if (checkStability.booleanValue()) {
                GravityMethods.disturbBlock(world, x, y + 1, z);
            } else {
                GravityMethods.dropBlock(world, x, y + 1, z, false);
            }
        }
    }

    public static void disturbBlock(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (BlockSets.fallingBlocks.containsKey(block) && GravityMethods.shouldFall(world, pos, BlockSets.fallingBlocks.get(block))) {
            GravityMethods.dropBlock(world, x, y, z, true);
        }
    }

    public static boolean shouldFall(World world, BlockPos pos, int stability) {
        Block block = world.func_180495_p(pos).func_177230_c();
        for (int loop = 1; loop < stability + 1; ++loop) {
            if (world.func_180495_p(pos.func_177981_b(loop)).func_177230_c() == block) continue;
            return true;
        }
        return false;
    }
}

