/*
 * Decompiled with CFR 0.152.
 */
package wtf.core.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wtf.core.blocks.AbstractBlockDerivative;
import wtf.core.blocks.BlockSpeleothemFrozen;
import wtf.core.init.WTFBlocks;

public class BlockSpeleothem
extends AbstractBlockDerivative {
    public static final IProperty<SpType> TYPE = PropertyEnum.func_177709_a((String)"type", SpType.class);
    public BlockSpeleothem frozen;

    public BlockSpeleothem(IBlockState state) {
        super(state, state);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)SpType.stalactite_small)));
        WTFBlocks.speleothemMap.put(state, this);
    }

    protected BlockSpeleothem(IBlockState backState, IBlockState foreState) {
        super(backState, foreState);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)SpType.stalactite_small)));
    }

    public Block setFrozen(String string) {
        this.frozen = (BlockSpeleothem)WTFBlocks.registerBlockItemSubblocks(new BlockSpeleothemFrozen(this), 6, "frozen_" + string);
        return this;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((SpType)((Object)state.func_177229_b(BlockSpeleothem.TYPE))).boundingBox;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        switch ((SpType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))) {
            case column: {
                return this.hasProperty(world.func_180495_p(pos.func_177977_b()), SpType.stalagmite_base) || this.hasProperty(world.func_180495_p(pos.func_177977_b()), SpType.column) || this.hasProperty(world.func_180495_p(pos.func_177984_a()), SpType.stalactite_base) || this.hasProperty(world.func_180495_p(pos.func_177984_a()), SpType.column);
            }
            case stalactite_base: {
                return world.func_180495_p(pos.func_177984_a()) == this.parentBackground;
            }
            case stalactite_small: {
                return world.func_180495_p(pos.func_177984_a()) == this.parentBackground;
            }
            case stalactite_tip: {
                return this.hasProperty(world.func_180495_p(pos.func_177984_a()), SpType.stalactite_base) || this.hasProperty(world.func_180495_p(pos.func_177984_a()), SpType.column);
            }
            case stalagmite_base: {
                return world.func_180495_p(pos.func_177977_b()) == this.parentBackground;
            }
            case stalagmite_small: {
                return world.func_180495_p(pos.func_177977_b()) == this.parentBackground;
            }
            case stalagmite_tip: {
                return this.hasProperty(world.func_180495_p(pos.func_177977_b()), SpType.stalagmite_base) || this.hasProperty(world.func_180495_p(pos.func_177977_b()), SpType.column);
            }
        }
        return true;
    }

    private boolean hasProperty(IBlockState state, SpType type) {
        if (state.func_177230_c() instanceof BlockSpeleothem) {
            return state.func_177229_b(TYPE) == type;
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)SpType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        SpType type = (SpType)((Object)state.func_177229_b(TYPE));
        return type.getID();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int loop = 0; loop < SpType.values().length; ++loop) {
            list.add(new ItemStack(itemIn, 1, loop));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getBlockState(SpType type) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public static enum SpType implements IStringSerializable
    {
        stalactite_small(0, "stalactite_small", new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f)),
        stalactite_base(1, "stalactite_base", new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f)),
        stalactite_tip(2, "stalactite_tip", new AxisAlignedBB((double)0.3f, (double)0.4f, (double)0.3f, (double)0.7f, 1.0, (double)0.7f)),
        column(3, "column", new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 1.0, (double)0.7f)),
        stalagmite_small(4, "stalagmite_small", new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f)),
        stalagmite_base(5, "stalagmite_base", new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f)),
        stalagmite_tip(6, "stalagmite_tip", new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f));

        private final int ID;
        private final String name;
        public final AxisAlignedBB boundingBox;

        private SpType(int ID, String name, AxisAlignedBB box) {
            this.ID = ID;
            this.name = name;
            this.boundingBox = box;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

