/*
 * Decompiled with CFR 0.152.
 */
package wtf.core.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wtf.core.blocks.AbstractBlockDerivative;
import wtf.core.init.BlockSets;

public class BlockIcicle
extends AbstractBlockDerivative {
    public static final IProperty<IcicleType> TYPE = PropertyEnum.func_177709_a((String)"type", IcicleType.class);

    public BlockIcicle(IBlockState state) {
        super(state, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        for (int loopx = -1; loopx < 2; ++loopx) {
            for (int loopy = -2; loopy < 1; ++loopy) {
                for (int loopz = -1; loopz < 2; ++loopz) {
                    BlockPos relpos = new BlockPos(pos.func_177958_n() + loopx, pos.func_177956_o() + loopy, pos.func_177952_p() + loopz);
                    if (!BlockSets.meltBlocks.contains(world.func_180495_p(relpos).func_177230_c())) continue;
                    return false;
                }
            }
        }
        switch ((IcicleType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))) {
            case icicle_base: {
                return world.func_180495_p(pos.func_177984_a()).func_185898_k();
            }
            case icicle_small: {
                return world.func_180495_p(pos.func_177984_a()).func_185898_k();
            }
            case icicle_tip: {
                return world.func_180495_p(pos.func_177984_a()) == this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)IcicleType.icicle_base));
            }
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)IcicleType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        IcicleType type = (IcicleType)((Object)state.func_177229_b(TYPE));
        return type.getID();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int loop = 0; loop < IcicleType.values().length; ++loop) {
            list.add(new ItemStack(itemIn, 1, loop));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((IcicleType)((Object)state.func_177229_b(BlockIcicle.TYPE))).boundingBox;
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public IBlockState getBlockState(IcicleType type) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public static enum IcicleType implements IStringSerializable
    {
        icicle_small(0, "stalactite_small", new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f)),
        icicle_base(1, "stalactite_base", new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f)),
        icicle_tip(2, "stalactite_tip", new AxisAlignedBB((double)0.3f, (double)0.4f, (double)0.3f, (double)0.7f, 1.0, (double)0.7f));

        private final int ID;
        private final String name;
        public final AxisAlignedBB boundingBox;

        private IcicleType(int ID, String name, AxisAlignedBB box) {
            this.ID = ID;
            this.name = name;
            this.boundingBox = box;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

