/*
 * Decompiled with CFR 0.152.
 */
package wtf.cavebiomes.worldgeneration;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import wtf.api.PopulationGenerator;
import wtf.cavebiomes.worldgeneration.AbstractCaveType;
import wtf.cavebiomes.worldgeneration.CaveBiomeGenMethods;
import wtf.cavebiomes.worldgeneration.CaveTypeRegister;
import wtf.cavebiomes.worldgeneration.cavetypes.CaveProfile;
import wtf.core.utilities.wrappers.AdjPos;
import wtf.core.utilities.wrappers.CaveListWrapper;
import wtf.core.utilities.wrappers.CavePosition;
import wtf.core.utilities.wrappers.ChunkCoords;
import wtf.core.utilities.wrappers.ChunkScan;

public class CavePopulator
extends PopulationGenerator {
    public void generate(World world, ChunkCoords coords, Random random, ChunkScan chunkscan) {
        CaveBiomeGenMethods gen = new CaveBiomeGenMethods(coords.getChunk(world), random);
        HashMap<ChunkCoords, CaveBiomeGenMethods> altGen = new HashMap<ChunkCoords, CaveBiomeGenMethods>();
        for (CaveListWrapper cave : chunkscan.caveset) {
            CaveProfile profile = CaveTypeRegister.getCaveProfile((Biome)cave.getBiome(world));
            double depth = (double)((float)cave.getAvgFloor()) / chunkscan.surfaceAvg;
            AbstractCaveType cavetype = profile.getCave((CavePosition)cave.cave.get(0), (int)chunkscan.surfaceAvg);
            for (BlockPos pos : cave.wall) {
                int x = pos.func_177958_n() >> 4;
                int z = pos.func_177958_n() >> 4;
                if (x != coords.getChunkX() || z != coords.getChunkX()) {
                    ChunkCoords adjCoords = new ChunkCoords(x, z);
                    CaveBiomeGenMethods adjGen = (CaveBiomeGenMethods)altGen.get(adjCoords);
                    if (adjGen == null) {
                        adjGen = new CaveBiomeGenMethods(adjCoords.getChunk(world), random);
                        altGen.put(adjCoords, adjGen);
                    }
                    cavetype.generateWall(adjGen, random, pos, (float)pos.func_177956_o() / (float)chunkscan.surfaceAvg, pos.func_177956_o() - (int)cave.getAvgFloor());
                    continue;
                }
                cavetype.generateWall(gen, random, pos, (float)pos.func_177956_o() / (float)chunkscan.surfaceAvg, pos.func_177956_o() - (int)cave.getAvgFloor());
            }
            for (AdjPos adj : cave.adjacentWall) {
                cavetype.generateAdjacentWall(gen, random, adj, (float)adj.getY() / (float)chunkscan.surfaceAvg, adj.getY() - (int)cave.getAvgFloor());
            }
            for (CavePosition position : cave.cave) {
                if (position.alreadyGenerated) continue;
                CavePopulator.generateCaveType(gen, profile.getCave(position, (int)chunkscan.surfaceAvg), world, random, position, (float)depth);
                position.alreadyGenerated = true;
            }
        }
        this.setBlockSet(gen);
        for (CaveBiomeGenMethods alt : altGen.values()) {
            this.setBlockSet(alt);
        }
    }

    public static void generateCaveType(CaveBiomeGenMethods gen, AbstractCaveType cavetype, World world, Random random, CavePosition pos, float depth) {
        cavetype.generateFloor(gen, random, pos.getFloorPos(), depth);
        cavetype.generateCeiling(gen, random, pos.getCeilingPos(), depth);
        if ((float)random.nextInt(100) < (float)cavetype.ceilingaddonchance + (1.0f - depth) * 5.0f) {
            cavetype.generateCeilingAddons(gen, random, pos.getCeilingPos().func_177977_b(), depth);
        }
        if ((float)random.nextInt(100) < (float)cavetype.flooraddonchance + (1.0f - depth) * 5.0f) {
            cavetype.generateFloorAddons(gen, random, pos.getFloorPos().func_177984_a(), depth);
        }
    }

    protected void setBlockSet(CaveBiomeGenMethods gen) {
        Chunk chunk = gen.chunk;
        for (Map.Entry entry : gen.blocksToSet.entrySet()) {
            chunk.func_177436_a((BlockPos)entry.getKey(), (IBlockState)entry.getValue());
        }
    }
}

