/*
 * Decompiled with CFR 0.152.
 */
package wtf.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wtf.Core;
import wtf.gameplay.StoneFractureMethods;
import wtf.init.BlockSets;

public class BlockPatchFluid
extends BlockLiquid {
    public IBlockState otherState;
    Block[] waterarray = new Block[]{Blocks.field_150355_j, Blocks.field_150358_i};
    Block[] lavaarray = new Block[]{Blocks.field_150356_k, Blocks.field_150353_l};
    HashSet<Block> water = new HashSet<Block>(Arrays.asList(this.waterarray));
    HashSet<Block> lava = new HashSet<Block>(Arrays.asList(this.lavaarray));
    private int airHash = Blocks.field_150350_a.hashCode();

    public BlockPatchFluid(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(7)));
        this.func_149647_a(Core.wtfTab);
        if (material == Material.field_151586_h) {
            // empty if block
        }
        if (material == Material.field_151587_i) {
            this.func_149715_a(0.8f);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return motion;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || !this.canBlockStay(worldIn, pos)) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else if (!this.func_176365_e(worldIn, pos, state)) {
            this.updateLiquid(worldIn, pos, state);
            worldIn.func_175656_a(pos, this.func_176223_P());
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        BlockPos[] sides;
        if (BlockSets.nonSolidBlockSet.contains(world.func_180495_p(pos.func_177977_b()))) {
            return false;
        }
        for (BlockPos adj : sides = new BlockPos[]{pos.func_177968_d(), pos.func_177978_c(), pos.func_177974_f(), pos.func_177976_e()}) {
            IBlockState state = world.func_180495_p(adj);
            if ((!this.water.contains(state.func_177230_c()) || (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) >= 7) && (!this.lava.contains(state.func_177230_c()) || (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) >= 6)) continue;
            if (this.func_176223_P().func_185904_a() == Material.field_151587_i) {
                StoneFractureMethods.frac(world, pos.func_177977_b(), -1);
            }
            return false;
        }
        return true;
    }

    protected int func_189542_i(IBlockState p_189542_1_) {
        return 7;
    }

    protected int func_189545_x(IBlockState p_189545_1_) {
        return 7;
    }

    private void updateLiquid(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        block12: {
            Block block;
            boolean foundThis = false;
            ArrayList<BlockPos> airPos = new ArrayList<BlockPos>();
            for (int xloop = -1; xloop < 2; ++xloop) {
                for (int zloop = -1; zloop < 2; ++zloop) {
                    BlockPos checkPos = new BlockPos(pos.func_177958_n() + xloop, pos.func_177956_o() - 1, pos.func_177952_p() + zloop);
                    block = worldIn.func_180495_p(checkPos).func_177230_c();
                    if (block.hashCode() == this.airHash && worldIn.func_180495_p(checkPos.func_177977_b()).hashCode() != this.airHash) {
                        airPos.add(checkPos);
                    }
                    if (block.hashCode() != ((Object)((Object)this)).hashCode()) continue;
                    foundThis = true;
                }
            }
            if (foundThis && airPos.size() > 0) {
                for (BlockPos setPos : airPos) {
                    worldIn.func_175656_a(setPos, this.func_176223_P());
                }
            }
            worldIn.func_175656_a(pos, this.otherState);
            if (this.field_149764_J != Material.field_151587_i || !worldIn.func_82736_K().func_82766_b("doFireTick")) break block12;
            int i = rand.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if ((blockpos = blockpos.func_177982_a(rand.nextInt(3) - 1, 1, rand.nextInt(3) - 1)).func_177956_o() >= 0 && blockpos.func_177956_o() < worldIn.func_72800_K() && !worldIn.func_175667_e(blockpos)) {
                        return;
                    }
                    block = worldIn.func_180495_p(blockpos).func_177230_c();
                    if (block.func_149688_o(state) == Material.field_151579_a) {
                        if (!this.isSurroundingBlockFlammable(worldIn, blockpos)) continue;
                        worldIn.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!block.func_149688_o(state).func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, 0, rand.nextInt(3) - 1);
                    if (blockpos1.func_177956_o() >= 0 && blockpos1.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos1)) {
                        return;
                    }
                    if (!worldIn.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn(worldIn, blockpos1)) continue;
                    worldIn.func_175656_a(blockpos1.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    protected boolean isSurroundingBlockFlammable(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    protected boolean getCanBlockBurn(World worldIn, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !worldIn.func_175667_e(pos) ? false : worldIn.func_180495_p(pos).func_185904_a().func_76217_h();
    }
}

