/*
 * Decompiled with CFR 0.152.
 */
package wtf.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wtf.blocks.AbstractBlockDerivative;
import wtf.blocks.BlockSpeleothem;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.StateAndModifier;

public class AnimatedBlock
extends AbstractBlockDerivative {
    public static final IProperty<ANIMTYPE> TYPE = PropertyEnum.func_177709_a((String)"type", ANIMTYPE.class);
    public static final PropertyBool FAST = PropertyBool.func_177716_a((String)"fast");

    public AnimatedBlock(IBlockState state) {
        super(state, state);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.LAVA_CRUST)).func_177226_a((IProperty)FAST, (Comparable)Boolean.valueOf(false)));
        BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.LAVA_CRUST), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.LAVA_CRUST)));
        BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.WATER_DRIP), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.DRIP_WATER)));
        BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.LAVA_DRIP), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.DRIP_LAVA)));
        BlockSpeleothem block = WTFBlocks.speleothemMap.get(state);
        WTFBlocks.speleothemMap.put(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.DRIP_WATER)), block);
        IBlockState fractured = BlockSets.blockTransformer.get(new StateAndModifier(state, BlockSets.Modifier.COBBLE));
        BlockSets.blockTransformer.put(new StateAndModifier(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.DRIP_WATER)), BlockSets.Modifier.COBBLE), fractured);
        BlockSets.blockTransformer.put(new StateAndModifier(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.DRIP_LAVA)), BlockSets.Modifier.COBBLE), fractured);
    }

    public IBlockState getBlockState(ANIMTYPE type) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public void setFast(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_177230_c() instanceof AnimatedBlock) {
            world.func_175656_a(pos, this.func_176203_a(this.func_176201_c(blockstate) + 8));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState other = worldIn.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(worldIn, pos);
        }
        if (((ANIMTYPE)((Object)state.func_177229_b(TYPE))).ID == 0) {
            return 12;
        }
        return 0;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        System.out.println("OnBlockDestroyedByPlayerCalled" + ((ANIMTYPE)((Object)state.func_177229_b(TYPE))).ID);
        if (((ANIMTYPE)((Object)state.func_177229_b(TYPE))).ID == 0) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        int chance;
        int n = chance = (Boolean)state.func_177229_b((IProperty)FAST) != false ? 5 : 20;
        if (random.nextInt(chance) == 0) {
            double x = (float)pos.func_177958_n() + random.nextFloat();
            double y = (double)pos.func_177956_o() - 0.05;
            double z = (float)pos.func_177952_p() + random.nextFloat();
            switch ((ANIMTYPE)((Object)state.func_177229_b(TYPE))) {
                case DRIP_LAVA: {
                    if (world.func_175677_d(pos.func_177977_b(), false)) break;
                    world.func_175688_a(EnumParticleTypes.DRIP_LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case DRIP_WATER: {
                    if (world.func_175677_d(pos.func_177977_b(), false)) break;
                    world.func_175688_a(EnumParticleTypes.DRIP_WATER, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case LAVA_CRUST: {
                    if (!world.func_175677_d(pos.func_177977_b(), false)) {
                        world.func_175688_a(EnumParticleTypes.DRIP_LAVA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (world.func_175677_d(pos.func_177984_a(), false)) break;
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y + 1.0, z, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
            }
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (((ANIMTYPE)((Object)state.func_177229_b(TYPE))).getID() == 0) {
            return layer == BlockRenderLayer.CUTOUT_MIPPED;
        }
        return super.canRenderInLayer(state, layer);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int loop = 0; loop < ANIMTYPE.values().length; ++loop) {
            list.add(new ItemStack(itemIn, 1, loop));
        }
    }

    public IBlockState func_176203_a(int meta) {
        boolean fast = false;
        if (meta > 7) {
            meta -= 7;
            fast = true;
        }
        if (meta > 2) {
            meta = 0;
        }
        IBlockState state = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ANIMTYPE.values()[meta])).func_177226_a((IProperty)FAST, (Comparable)Boolean.valueOf(fast));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i = ((ANIMTYPE)((Object)state.func_177229_b(TYPE))).getID();
        if (((Boolean)state.func_177229_b((IProperty)FAST)).booleanValue()) {
            i += 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FAST});
    }

    public static enum ANIMTYPE implements IStringSerializable
    {
        LAVA_CRUST(0, "lava_crust", BlockSets.Modifier.LAVA_CRUST),
        DRIP_WATER(1, "drip_water", BlockSets.Modifier.WATER_DRIP),
        DRIP_LAVA(2, "drip_lava", BlockSets.Modifier.LAVA_DRIP);

        private final int ID;
        private final String name;
        public final BlockSets.Modifier modifier;

        private ANIMTYPE(int ID, String name, BlockSets.Modifier mod) {
            this.ID = ID;
            this.name = name;
            this.modifier = mod;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

