/*
 * Decompiled with CFR 0.152.
 */
package wtf.biomes.trees;

import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import wtf.biomes.TreeVars;

public class SimpleTree
extends TreeVars {
    public SimpleTree(World world, IBlockState wood, IBlockState branch, IBlockState leaf, boolean vines) {
        super(world, wood, branch, leaf);
        if (vines) {
            this.vines = this.random.nextInt(3) + 1;
        }
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return this.random.nextInt(2) + 3;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 2.0;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.5;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = nodeHeight / trunkHeight;
        return 1.0 + trunkHeight / 4.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(4 + this.random.nextInt(3) + 1) + 3.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return 2.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 1.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return (int)trunkHeight;
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.8 + (double)this.random.nextFloat();
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return 4;
    }
}

