/*
 * Decompiled with CFR 0.152.
 */
package wtf.biomes.components;

import net.minecraft.block.BlockLog;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class Branch {
    public final double length;
    public final double oriX;
    public final double oriY;
    public final double oriZ;
    public final double vecX;
    public final double vecZ;
    public final double vecY;
    protected double x;
    protected double y;
    protected double z;
    public int count = 0;
    public final BlockLog.EnumAxis axis;

    public Branch(double oriX, double oriY, double oriZ, double x, double y, double z, double rootLength) {
        this.oriX = oriX;
        this.oriY = oriY;
        this.oriZ = oriZ;
        this.vecX = x;
        this.vecY = y;
        this.vecZ = z;
        this.length = rootLength + 1.0;
        this.x = oriX;
        this.y = oriY;
        this.z = oriZ;
        this.axis = Math.abs(this.vecY) < MathHelper.func_76132_a((double)this.vecX, (double)this.vecZ) ? (Math.abs(this.vecX) > Math.abs(this.vecZ) ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z) : BlockLog.EnumAxis.Y;
    }

    public boolean hasNext() {
        double xlength = this.x - this.oriX;
        double ylength = this.y - this.oriY;
        double zlength = this.z - this.oriZ;
        return xlength * xlength + ylength * ylength + zlength * zlength < this.length * this.length;
    }

    public BlockPos next() {
        this.x += this.vecX;
        this.y += this.vecY;
        this.z += this.vecZ;
        ++this.count;
        return new BlockPos(this.x, this.y, this.z);
    }

    public BlockPos pos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public BlockPos lateralNext() {
        if (this.x == 0.0 && this.z == 0.0) {
            this.y = this.y > 0.0 ? this.y + 1.0 : this.y - 1.0;
            return new BlockPos(this.x, this.y, this.z);
        }
        this.x += this.vecX;
        this.z += this.vecZ;
        return new BlockPos(this.x, this.y, this.z);
    }

    public BlockPos getAdjacent1() {
        return this.vecX > this.vecZ ? this.pos().func_177978_c() : this.pos().func_177974_f();
    }

    public BlockPos getAdjacent2() {
        return this.vecX > this.vecZ ? this.pos().func_177968_d() : this.pos().func_177976_e();
    }

    public int getCount() {
        return this.count;
    }
}

