/*
 * Decompiled with CFR 0.152.
 */
package wtf.biomes;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import wtf.api.PopulationGenerator;
import wtf.biomes.GenTree;
import wtf.biomes.TreePos;
import wtf.biomes.TreeTypeGetter;
import wtf.biomes.TreeVars;
import wtf.core.utilities.wrappers.ChunkCoords;
import wtf.core.utilities.wrappers.ChunkScan;
import wtf.core.utilities.wrappers.SurfacePos;

public class TreePopulator
extends PopulationGenerator {
    public void generate(World world, ChunkCoords chunkcoords, Random random, ChunkScan surface2) throws Exception {
        this.genTrees(world, surface2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void genTrees(World world, ChunkScan chunkscan) throws Exception {
        Biome biome = world.func_180494_b(new BlockPos(chunkscan.chunkX, 100, chunkscan.chunkZ));
        int numTrees = MathHelper.func_76143_f((double)biome.field_76760_I.field_76832_z);
        ArrayList<WorldGenAbstractTree> shrubgenerators = new ArrayList<WorldGenAbstractTree>();
        block0: for (int n = 0; n < numTrees; ++n) {
            WorldGenAbstractTree oldTree = biome.func_150567_a(world.field_73012_v);
            if (oldTree == null) {
                return;
            }
            if (oldTree instanceof WorldGenShrub) {
                shrubgenerators.add(oldTree);
            } else {
                SurfacePos pos;
                TreeVars treeType = TreeTypeGetter.getTree((World)world, (WorldGenAbstractTree)oldTree);
                if (treeType != null) {
                    pos = chunkscan.getPosForTreeGeneration(world, treeType);
                    if (pos == null) break;
                    TreePos tree = new TreePos(world, world.field_73012_v, chunkscan, (BlockPos)pos, treeType);
                    if (!GenTree.generate(tree)) {
                        // empty if block
                    }
                } else if (oldTree != null) {
                    pos = chunkscan.getRandomNotGenerated(world.field_73012_v);
                    if (pos == null) break;
                    oldTree.func_180709_b(world, world.field_73012_v, (BlockPos)pos);
                }
            }
            for (WorldGenAbstractTree shrub : shrubgenerators) {
                SurfacePos pos = chunkscan.getRandomNotGenerated(world.field_73012_v);
                if (pos == null) continue block0;
                shrub.func_180709_b(world, world.field_73012_v, (BlockPos)pos);
            }
        }
    }
}

