/*
 * Decompiled with CFR 0.152.
 */
package wtf.api;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.BlockSnapshot;
import wtf.utilities.GenMethods;
import wtf.utilities.wrappers.BlockToPlace;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;

public abstract class PopulationGenerator {
    protected HashSet<BlockToPlace> blocksToPlace = new HashSet();

    public abstract void generate(World var1, ChunkCoords var2, Random var3, ChunkScan var4) throws Exception;

    protected boolean addBlock(World world, BlockPos pos, IBlockState blockstate) {
        return GenMethods.setBlockState(world, pos, blockstate);
    }

    protected boolean addBlock(World world, int x, int y, int z, IBlockState blockstate) {
        return GenMethods.setBlockState(world, new BlockPos(x, y, z), blockstate);
    }

    protected void setBlockSet(World world, HashSet<BlockToPlace> blockset) {
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g || blockset.isEmpty()) {
            return;
        }
        Iterator<BlockToPlace> iterator = blockset.iterator();
        BlockToPlace blockpos = iterator.next();
        block0: while (iterator.hasNext()) {
            int chunkX = blockpos.x >> 4;
            int chunkZ = blockpos.z >> 4;
            Chunk chunk = world.func_72964_e(chunkX, chunkZ);
            BlockSnapshot blockSnapshot = null;
            if (world.captureBlockSnapshots && !world.field_72995_K) {
                blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)blockpos.blockpos, (int)0);
                world.capturedBlockSnapshots.add(blockSnapshot);
            }
            while (chunkX == blockpos.x >> 4 && chunkZ == blockpos.z >> 4) {
                chunk.func_177436_a(blockpos.blockpos, blockpos.state);
                if (!iterator.hasNext()) continue block0;
                blockpos = iterator.next();
            }
        }
    }
}

