/*
 * Decompiled with CFR 0.152.
 */
package wtf;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;
import wtf.api.WTFWorldGen;
import wtf.config.CaveBiomesConfig;
import wtf.config.CoreConfig;
import wtf.config.GameplayConfig;
import wtf.config.OverworldGenConfig;
import wtf.crafting.GuiHandler;
import wtf.crafting.RecipeParser;
import wtf.entities.EntitySpawnListener;
import wtf.gameplay.AppleCoreEvents;
import wtf.gameplay.GamePlayEventListener;
import wtf.init.BlockSets;
import wtf.init.LootEventListener;
import wtf.init.WTFArmor;
import wtf.init.WTFBiomes;
import wtf.init.WTFBlocks;
import wtf.init.WTFEntities;
import wtf.init.WTFItems;
import wtf.init.WTFRecipes;
import wtf.ores.OreGenerator;
import wtf.ores.VanillOreGenCatcher;
import wtf.ores.config.WTFOreConfig;
import wtf.proxy.CommonProxy;
import wtf.worldgen.DungeonPopulator;
import wtf.worldgen.OverworldGen;
import wtf.worldgen.PopulationDecorator;
import wtf.worldgen.RTGOverworldGen;
import wtf.worldgen.trees.WorldGenTreeCancel;
import wtf.worldscan.CoreWorldGenListener;

@Mod(modid="wtfcore", name="wtfcore", version="1.10_BetaX", acceptedMinecraftVersions="[1.10.2]")
public class Core {
    public static final String coreID = "wtfcore";
    public static final String version = "1.10_BetaX";
    @SidedProxy(clientSide="wtf.proxy.ClientProxy", serverSide="wtf.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Logger coreLog;
    @Mod.Instance(value="wtfcore")
    public static Core instance;
    public static CreativeTabs wtfTab;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent preEvent) throws Exception {
        coreLog = preEvent.getModLog();
        CoreConfig.loadConfig();
        GameplayConfig.loadConfig();
        OverworldGenConfig.loadConfig();
        CaveBiomesConfig.customConfig();
        BlockSets.initBlockSets();
        WTFBlocks.initBlocks(preEvent);
        proxy.initWCICRender();
        WTFItems.initItems();
        WTFArmor.initArmor();
        WTFEntities.initEntites();
        WTFRecipes.initRecipes();
        if (CoreConfig.enableOverworldGeneration) {
            WTFBiomes.init();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (CoreConfig.enableOreGen) {
            WTFOreConfig.loadConfig();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws Exception {
        MinecraftForge.EVENT_BUS.register((Object)new CoreWorldGenListener());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new CoreWorldGenListener());
        if (CoreConfig.dungeonGeneration) {
            WTFWorldGen.addGen(new DungeonPopulator());
        }
        if (CoreConfig.mobReplacement) {
            MinecraftForge.EVENT_BUS.register((Object)new EntitySpawnListener());
        }
        if (CoreConfig.gameplaytweaks) {
            MinecraftForge.EVENT_BUS.register((Object)new GamePlayEventListener());
            MinecraftForge.EVENT_BUS.register((Object)new LootEventListener());
        }
        if (CoreConfig.enableOreGen) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new VanillOreGenCatcher());
            WTFWorldGen.addGen(new OreGenerator());
        }
        if (CoreConfig.enableOverworldGeneration && OverworldGenConfig.genTrees) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldGenTreeCancel());
            MinecraftForge.EVENT_BUS.register((Object)new WorldGenTreeCancel());
        }
        if (Loader.isModLoaded((String)"AppleCore")) {
            coreLog.info("AppleCore detected, registering integration");
            AppleCoreEvents.initGrowthMap();
            MinecraftForge.EVENT_BUS.register((Object)new AppleCoreEvents());
        }
        if (CoreConfig.enableOverworldGeneration) {
            if (Loader.isModLoaded((String)"RTG")) {
                coreLog.info(";RTG detected, enabling integration");
                WTFWorldGen.addGen(new RTGOverworldGen());
            } else {
                WTFWorldGen.addGen(new OverworldGen());
            }
        }
        WTFWorldGen.addGen(new PopulationDecorator());
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent postEvent) throws Exception {
        System.out.println("Torch class is now " + Blocks.field_150478_aa.getClass());
        RecipeParser.init();
    }

    static {
        wtfTab = new CreativeTabs("WTFBlocks"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)Blocks.field_150347_e);
            }
        };
    }
}

