/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock.tesr;

import java.lang.ref.SoftReference;
import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseledTESR;
import mod.chiselsandbits.chiseledblock.data.VoxelNeighborRenderTracker;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.render.chiseledblock.ChiselLayer;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockRenderChunkTESR;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;

public class ChisledBlockBackgroundRender
implements Callable<Tessellator> {
    private final List<TileEntityBlockChiseledTESR> myPrivateList;
    private final BlockRenderLayer layer;
    private final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
    private static final Queue<SoftReference<Tessellator>> previousTessellators = new LinkedBlockingQueue<SoftReference<Tessellator>>();
    private final ChunkCache cache;
    private final BlockPos chunkOffset;

    public ChisledBlockBackgroundRender(ChunkCache cache, BlockPos chunkOffset, List<TileEntityBlockChiseledTESR> myList, BlockRenderLayer layer) {
        this.myPrivateList = myList;
        this.layer = layer;
        this.cache = cache;
        this.chunkOffset = chunkOffset;
    }

    public static void submitTessellator(Tessellator t) {
        previousTessellators.add(new SoftReference<Tessellator>(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Tessellator call() throws Exception {
        tessellator = null;
        while (true) {
            if ((softTessellator = ChisledBlockBackgroundRender.previousTessellators.poll()) != null) {
                tessellator = softTessellator.get();
            }
            if (tessellator == null && !ChisledBlockBackgroundRender.previousTessellators.isEmpty()) continue;
            if (tessellator == null) {
                softTessellator = CBTessellator.class;
                // MONITORENTER : mod.chiselsandbits.render.chiseledblock.tesr.ChisledBlockBackgroundRender$CBTessellator.class
                if (ChisledBlockRenderChunkTESR.activeTess.get() < ChisledBlockRenderChunkTESR.getMaxTessalators()) {
                    tessellator = new CBTessellator(0x203200);
                } else {
                    Thread.sleep(10L);
                }
                // MONITOREXIT : softTessellator
            }
            if (tessellator != null) break;
        }
        worldrenderer = tessellator.func_178180_c();
        try {
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            worldrenderer.func_178969_c((double)(-this.chunkOffset.func_177958_n()), (double)(-this.chunkOffset.func_177956_o()), (double)(-this.chunkOffset.func_177952_p()));
        }
        catch (IllegalStateException e) {
            Log.logError("Invalid Tessellator Behavior", e);
        }
        faceCount = new int[BlockRenderLayer.values().length];
        mcLayers = EnumSet.noneOf(BlockRenderLayer.class);
        layers = this.layer == BlockRenderLayer.TRANSLUCENT ? EnumSet.of(ChiselLayer.TRANSLUCENT) : EnumSet.complementOf(EnumSet.of(ChiselLayer.TRANSLUCENT));
        var6_7 = this.myPrivateList.iterator();
        block5: while (true) {
            if (!var6_7.hasNext()) {
                if (Thread.interrupted() == false) return tessellator;
                worldrenderer.func_178977_d();
                ChisledBlockBackgroundRender.submitTessellator(tessellator);
                return null;
            }
            var7_8 = var6_7.next();
            if (!(var7_8 instanceof TileEntityBlockChiseledTESR) || var7_8.func_145837_r()) continue;
            estate = ((TileEntityBlockChiseledTESR)var7_8).getTileRenderState((IBlockAccess)this.cache);
            mcLayers.clear();
            for (ChiselLayer lx : layers) {
                mcLayers.add(lx.layer);
                model = ChiseledBlockSmartModel.getCachedModel(var7_8, lx);
                v0 = lx.layer.ordinal();
                faceCount[v0] = faceCount[v0] + model.faceCount();
                if (model.isEmpty()) continue;
                this.blockRenderer.func_175019_b().func_178267_a((IBlockAccess)this.cache, (IBakedModel)model, (IBlockState)estate, var7_8.func_174877_v(), worldrenderer, true);
                if (!Thread.interrupted()) continue;
                worldrenderer.func_178977_d();
                ChisledBlockBackgroundRender.submitTessellator(tessellator);
                return null;
            }
            rTracker = (VoxelNeighborRenderTracker)estate.getValue(BlockChiseled.UProperty_VoxelNeighborState);
            if (rTracker == null) continue;
            var10_11 = mcLayers.iterator();
            while (true) {
                if (var10_11.hasNext()) ** break;
                continue block5;
                brl = (BlockRenderLayer)var10_11.next();
                rTracker.setAbovelimit(brl, faceCount[brl.ordinal()]);
                faceCount[brl.ordinal()] = 0;
            }
            break;
        }
    }

    static class CBTessellator
    extends Tessellator {
        public CBTessellator(int bufferSize) {
            super(bufferSize);
            ChisledBlockRenderChunkTESR.activeTess.incrementAndGet();
        }

        protected void finalize() throws Throwable {
            ChisledBlockRenderChunkTESR.activeTess.decrementAndGet();
        }
    }
}

