/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.BlockChisled;

import java.util.WeakHashMap;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobState;
import mod.chiselsandbits.render.BaseSmartModel;
import mod.chiselsandbits.render.BlockChisled.ChisledBlockBaked;
import mod.chiselsandbits.render.MergedBakedModel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ChisledBlockSmartModel
extends BaseSmartModel
implements ISmartItemModel,
ISmartBlockModel {
    private static final WeakHashMap<VoxelBlobState, ChisledBlockBaked>[] modelCache = new WeakHashMap[4];
    private static final WeakHashMap<ItemStack, IBakedModel> itemToModel = new WeakHashMap();

    public static int getSides(TileEntityBlockChiseled te) {
        ChisledBlockBaked model = ChisledBlockSmartModel.getCachedModel(te, EnumWorldBlockLayer.SOLID);
        return model.sides;
    }

    public static ChisledBlockBaked getCachedModel(TileEntityBlockChiseled te, EnumWorldBlockLayer layer) {
        IExtendedBlockState myState = te.getState();
        VoxelBlobState data = (VoxelBlobState)myState.getValue(BlockChiseled.v_prop);
        Integer blockP = (Integer)myState.getValue(BlockChiseled.block_prop);
        blockP = blockP == null ? 0 : blockP;
        return ChisledBlockSmartModel.getCachedModel(blockP, data, layer);
    }

    private static ChisledBlockBaked getCachedModel(Integer blockP, VoxelBlobState data, EnumWorldBlockLayer layer) {
        if (data == null) {
            return new ChisledBlockBaked(blockP, layer, data);
        }
        ChisledBlockBaked out = modelCache[layer.ordinal()].get(data);
        if (out == null) {
            out = new ChisledBlockBaked(blockP, layer, data);
            modelCache[layer.ordinal()].put(data, out);
        }
        return out;
    }

    public IBakedModel handleBlockState(IBlockState state) {
        IExtendedBlockState myState = (IExtendedBlockState)state;
        VoxelBlobState data = (VoxelBlobState)myState.getValue(BlockChiseled.v_prop);
        Integer blockP = (Integer)myState.getValue(BlockChiseled.block_prop);
        blockP = blockP == null ? 0 : blockP;
        EnumWorldBlockLayer layer = MinecraftForgeClient.getRenderLayer();
        return ChisledBlockSmartModel.getCachedModel(blockP, data, layer);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        Object mdl = itemToModel.get(stack);
        if (mdl != null) {
            return mdl;
        }
        NBTTagCompound c = stack.func_77978_p();
        if (c == null) {
            return this;
        }
        if ((c = c.func_74775_l("BlockEntityTag")) == null) {
            return this;
        }
        byte[] data = c.func_74770_j("v");
        Integer blockP = c.func_74762_e("b");
        IFlexibleBakedModel[] models = new IFlexibleBakedModel[EnumWorldBlockLayer.values().length];
        for (EnumWorldBlockLayer l : EnumWorldBlockLayer.values()) {
            ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)l);
            models[l.ordinal()] = ChisledBlockSmartModel.getCachedModel(blockP, new VoxelBlobState(data, 0L), l);
        }
        ForgeHooksClient.setRenderLayer((EnumWorldBlockLayer)EnumWorldBlockLayer.SOLID);
        mdl = new MergedBakedModel(models);
        itemToModel.put(stack, (IBakedModel)mdl);
        return mdl;
    }

    static {
        int count = EnumWorldBlockLayer.values().length;
        if (modelCache.length != count) {
            throw new RuntimeException("Invalid Number of EnumWorldBlockLayer");
        }
        for (EnumWorldBlockLayer l : EnumWorldBlockLayer.values()) {
            ChisledBlockSmartModel.modelCache[l.ordinal()] = new WeakHashMap();
        }
    }
}

