/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.BlockChisled;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Vector3f;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.ClientSide;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobState;
import mod.chiselsandbits.items.BitColors;
import mod.chiselsandbits.render.BaseBakedModel;
import mod.chiselsandbits.render.BlockChisled.FaceRegion;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.ISmartBlockModel;

public class ChisledBlockBaked
extends BaseBakedModel {
    IBakedModel originalModel;
    final List<BakedQuad>[] face = new List[6];
    List<BakedQuad> generic;
    EnumWorldBlockLayer myLayer;
    public int sides = 0;
    public static final float pixelsPerBlock = 16.0f;
    private static final EnumFacing[] X_Faces = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST};
    private static final EnumFacing[] Y_Faces = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private static final EnumFacing[] Z_Faces = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};
    static boolean hasFaceMap = false;
    static int[][] faceVertMap = new int[6][4];

    public ChisledBlockBaked(int BlockRef, EnumWorldBlockLayer layer, VoxelBlobState data) {
        VoxelBlob vb;
        this.myLayer = layer;
        IBlockState state = Block.func_176220_d((int)BlockRef);
        this.initEmpty();
        if (state != null) {
            this.originalModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        }
        if (this.originalModel != null && data != null && (vb = data.getVoxelBlob()) != null && vb.filter(layer)) {
            this.face[0] = new ArrayList<BakedQuad>();
            this.face[1] = new ArrayList<BakedQuad>();
            this.face[2] = new ArrayList<BakedQuad>();
            this.face[3] = new ArrayList<BakedQuad>();
            this.face[4] = new ArrayList<BakedQuad>();
            this.face[5] = new ArrayList<BakedQuad>();
            this.generic = new ArrayList<BakedQuad>();
            this.generateFaces(vb, data.weight);
        }
    }

    private void initEmpty() {
        this.face[0] = Collections.emptyList();
        this.face[1] = Collections.emptyList();
        this.face[2] = Collections.emptyList();
        this.face[3] = Collections.emptyList();
        this.face[4] = Collections.emptyList();
        this.face[5] = Collections.emptyList();
        this.generic = Collections.emptyList();
    }

    private void generateFaces(VoxelBlob blob, long weight) {
        FaceBakery faceBakery = new FaceBakery();
        BlockPartRotation bpr = null;
        ModelRotation mr = ModelRotation.X0_Y0;
        HashMap<Integer, HashMap<Integer, ArrayList<FaceRegion>>> rset = new HashMap<Integer, HashMap<Integer, ArrayList<FaceRegion>>>();
        HashMap<Integer, float[]> sourceUVCache = new HashMap<Integer, float[]>();
        VoxelBlob.VisibleFace visFace = new VoxelBlob.VisibleFace();
        this.processXFaces(blob, visFace, rset);
        this.processYFaces(blob, visFace, rset);
        this.processZFaces(blob, visFace, rset);
        float[] defUVs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        this.sides = blob.getSideFlags(0, 15, 256);
        for (HashMap<Integer, ArrayList<FaceRegion>> srcX : rset.values()) {
            for (ArrayList<FaceRegion> src : srcX.values()) {
                this.mergeFaces(src);
                for (FaceRegion region : src) {
                    EnumFacing myFace = region.face;
                    Vector3f to = ChisledBlockBaked.offsetVec(region.max, myFace, 1);
                    Vector3f from = ChisledBlockBaked.offsetVec(region.min, myFace, -1);
                    IBlockState state = Block.func_176220_d((int)region.blockStateID);
                    IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
                    TextureAtlasSprite texture = ClientSide.findTexture(region.blockStateID, model);
                    BlockFaceUV uv = new BlockFaceUV(defUVs, 0);
                    BlockPartFace bpf = new BlockPartFace(myFace, -1, "", uv);
                    float[] uvs = this.getFaceUvs(myFace, from, to, this.getSourceUVs(sourceUVCache, region.blockStateID, weight, texture, myFace));
                    BakedQuad g = faceBakery.func_178414_a(to, from, bpf, texture, myFace, mr, bpr, true, true);
                    IColoredBakedQuad.ColoredBakedQuad q = new IColoredBakedQuad.ColoredBakedQuad(g.func_178209_a(), g.func_178211_c(), g.func_178210_d());
                    int[] vertData = q.func_178209_a();
                    int wrapAt = vertData.length / 4;
                    int color = BitColors.getColorFor(state, this.myLayer.ordinal());
                    vertData[3] = this.getShadeColor(vertData, 0, region, blob, color);
                    vertData[wrapAt * 1 + 3] = this.getShadeColor(vertData, wrapAt * 1, region, blob, color);
                    vertData[wrapAt * 2 + 3] = this.getShadeColor(vertData, wrapAt * 2, region, blob, color);
                    vertData[wrapAt * 3 + 3] = this.getShadeColor(vertData, wrapAt * 3, region, blob, color);
                    ChisledBlockBaked.calcVertFaceMap();
                    for (int vertNum = 0; vertNum < 4; ++vertNum) {
                        vertData[vertNum * wrapAt + 4] = Float.floatToRawIntBits(texture.func_94214_a((double)uvs[faceVertMap[myFace.func_176745_a()][vertNum] * 2 + 0]));
                        vertData[vertNum * wrapAt + 5] = Float.floatToRawIntBits(texture.func_94207_b((double)uvs[faceVertMap[myFace.func_176745_a()][vertNum] * 2 + 1]));
                    }
                    if (region.isEdge) {
                        this.face[myFace.ordinal()].add((BakedQuad)q);
                        continue;
                    }
                    this.generic.add((BakedQuad)q);
                }
            }
        }
    }

    private void mergeFaces(ArrayList<FaceRegion> src) {
        boolean restart = false;
        block0: do {
            restart = false;
            int size = src.size();
            int size_minus_one = size - 1;
            for (int x = 0; x < size_minus_one; ++x) {
                FaceRegion A = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion B = src.get(y);
                    if (!A.extend(B)) continue;
                    src.set(y, src.get(size_minus_one));
                    src.remove(size_minus_one);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processXFaces(VoxelBlob blob, VoxelBlob.VisibleFace visFace, HashMap<Integer, HashMap<Integer, ArrayList<FaceRegion>>> rset) {
        for (EnumFacing myFace : X_Faces) {
            for (int x = 0; x < blob.detail; ++x) {
                for (int z = 0; z < blob.detail; ++z) {
                    FaceRegion currentFace = null;
                    for (int y = 0; y < blob.detail; ++y) {
                        FaceRegion region = this.getRegion(blob, myFace, x, y, z, visFace);
                        if (region == null) {
                            currentFace = null;
                            continue;
                        }
                        if (currentFace != null && currentFace.extend(region)) continue;
                        currentFace = region;
                        this.addBucketedFace(rset, this.getBucket(myFace, x, y, z), region);
                    }
                    currentFace = null;
                }
            }
        }
    }

    private void processYFaces(VoxelBlob blob, VoxelBlob.VisibleFace visFace, HashMap<Integer, HashMap<Integer, ArrayList<FaceRegion>>> rset) {
        for (EnumFacing myFace : Y_Faces) {
            for (int y = 0; y < blob.detail; ++y) {
                for (int z = 0; z < blob.detail; ++z) {
                    FaceRegion currentFace = null;
                    for (int x = 0; x < blob.detail; ++x) {
                        FaceRegion region = this.getRegion(blob, myFace, x, y, z, visFace);
                        if (region == null) {
                            currentFace = null;
                            continue;
                        }
                        if (currentFace != null && currentFace.extend(region)) continue;
                        currentFace = region;
                        this.addBucketedFace(rset, this.getBucket(myFace, x, y, z), region);
                    }
                    currentFace = null;
                }
            }
        }
    }

    private void processZFaces(VoxelBlob blob, VoxelBlob.VisibleFace visFace, HashMap<Integer, HashMap<Integer, ArrayList<FaceRegion>>> rset) {
        for (EnumFacing myFace : Z_Faces) {
            for (int z = 0; z < blob.detail; ++z) {
                for (int y = 0; y < blob.detail; ++y) {
                    FaceRegion currentFace = null;
                    for (int x = 0; x < blob.detail; ++x) {
                        FaceRegion region = this.getRegion(blob, myFace, x, y, z, visFace);
                        if (region == null) {
                            currentFace = null;
                            continue;
                        }
                        if (currentFace != null && currentFace.extend(region)) continue;
                        currentFace = region;
                        this.addBucketedFace(rset, this.getBucket(myFace, x, y, z), region);
                    }
                    currentFace = null;
                }
            }
        }
    }

    private void addBucketedFace(HashMap<Integer, HashMap<Integer, ArrayList<FaceRegion>>> rset, int bucket, FaceRegion region) {
        ArrayList<FaceRegion> X;
        HashMap<Integer, ArrayList<FaceRegion>> h = rset.get(bucket);
        if (h == null) {
            h = new HashMap();
            rset.put(bucket, h);
        }
        if ((X = h.get(bucket)) == null) {
            X = new ArrayList();
            h.put(bucket, X);
        }
        X.add(region);
    }

    private int getShadeColor(int[] vertData, int offset, FaceRegion region, VoxelBlob blob, int color) {
        return this.getShadeColor(region.face, 1.0f, color);
    }

    private FaceRegion getRegion(VoxelBlob blob, EnumFacing myFace, int x, int y, int z, VoxelBlob.VisibleFace visFace) {
        blob.visibleFace(myFace, x, y, z, visFace);
        if (visFace.visibleFace) {
            Vec3i off = myFace.func_176730_m();
            Vec3i center = new Vec3i(x * 2 + 1 + off.func_177958_n(), y * 2 + 1 + off.func_177956_o(), z * 2 + 1 + off.func_177952_p());
            return new FaceRegion(myFace, center, visFace.state, visFace.isEdge);
        }
        return null;
    }

    private int getBucket(EnumFacing face, int x, int y, int z) {
        switch (face) {
            case DOWN: 
            case UP: {
                return y << 5 | face.ordinal();
            }
            case EAST: 
            case WEST: {
                return x << 5 | face.ordinal();
            }
            case SOUTH: 
            case NORTH: {
                return z << 5 | face.ordinal();
            }
        }
        return 0;
    }

    private float getFaceBrightness(EnumFacing face) {
        switch (face) {
            case DOWN: {
                return 0.5f;
            }
            case UP: {
                return 1.0f;
            }
            case SOUTH: 
            case NORTH: {
                return 0.8f;
            }
            case EAST: 
            case WEST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    private int getShadeColor(EnumFacing face, float f, int color) {
        int i = MathHelper.func_76125_a((int)((int)((f *= this.getFaceBrightness(face)) * 255.0f)), (int)0, (int)255);
        int r = (color >> 16 & 0xFF) * i / 255;
        int g = (color >> 8 & 0xFF) * i / 255;
        int b = (color & 0xFF) * i / 255;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    static void calcVertFaceMap() {
        hasFaceMap = true;
        Vector3f to = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f from = new Vector3f(16.0f, 16.0f, 16.0f);
        for (EnumFacing myFace : EnumFacing.field_82609_l) {
            FaceBakery faceBakery = new FaceBakery();
            BlockPartRotation bpr = null;
            ModelRotation mr = ModelRotation.X0_Y0;
            float[] defUVs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            BlockFaceUV uv = new BlockFaceUV(defUVs, 0);
            BlockPartFace bpf = new BlockPartFace(myFace, 0, "", uv);
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            BakedQuad q = faceBakery.func_178414_a(to, from, bpf, texture, myFace, mr, bpr, true, true);
            int[] vertData = q.func_178209_a();
            int a = 0;
            int b = 2;
            switch (myFace) {
                case SOUTH: 
                case NORTH: {
                    a = 0;
                    b = 1;
                    break;
                }
                case EAST: 
                case WEST: {
                    a = 1;
                    b = 2;
                    break;
                }
            }
            int p = vertData.length / 4;
            for (int vertNum = 0; vertNum < 4; ++vertNum) {
                ChisledBlockBaked.faceVertMap[myFace.func_176745_a()][vertNum] = ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + a])) && ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + b])) ? 0 : (ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + a])) && ChisledBlockBaked.isOne(Float.intBitsToFloat(vertData[vertNum * p + b])) ? 3 : (ChisledBlockBaked.isOne(Float.intBitsToFloat(vertData[vertNum * p + a])) && ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + b])) ? 1 : 2));
            }
        }
    }

    private float[] getSourceUVs(HashMap<Integer, float[]> sourceUVCache, int id, long weight, TextureAtlasSprite texture, EnumFacing myFace) {
        float[] quadUVs = sourceUVCache.get(id << 4 | myFace.func_176745_a());
        if (quadUVs == null) {
            quadUVs = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(Block.func_176220_d((int)id));
            if (model != null) {
                List quads;
                if (model != null && ChiselsAndBits.instance.config.allowBlockAlternatives && model instanceof WeightedBakedModel) {
                    model = ((WeightedBakedModel)model).func_177564_a(weight);
                }
                try {
                    IBakedModel newModel;
                    if (model instanceof ISmartBlockModel && (newModel = ((ISmartBlockModel)model).handleBlockState(Block.func_176220_d((int)id))) != null) {
                        model = newModel;
                    }
                }
                catch (Exception newModel) {
                    // empty catch block
                }
                if (model != null && (quads = model.func_177551_a(myFace)).size() == 1) {
                    BakedQuad src = (BakedQuad)quads.get(0);
                    int[] vertData = src.func_178209_a();
                    float minU = texture.func_94209_e();
                    float maxUMinusMin = texture.func_94212_f() - minU;
                    float minV = texture.func_94206_g();
                    float maxVMinusMin = texture.func_94210_h() - minV;
                    int a = 0;
                    int b = 2;
                    switch (myFace) {
                        case SOUTH: 
                        case NORTH: {
                            a = 0;
                            b = 1;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            a = 1;
                            b = 2;
                            break;
                        }
                    }
                    int p = vertData.length / 4;
                    for (int vertNum = 0; vertNum < 4; ++vertNum) {
                        if (ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + a])) && ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + b]))) {
                            quadUVs[0] = (Float.intBitsToFloat(vertData[vertNum * p + 4]) - minU) / maxUMinusMin;
                            quadUVs[1] = (Float.intBitsToFloat(vertData[vertNum * p + 5]) - minV) / maxVMinusMin;
                            continue;
                        }
                        if (ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + a])) && ChisledBlockBaked.isOne(Float.intBitsToFloat(vertData[vertNum * p + b]))) {
                            quadUVs[4] = (Float.intBitsToFloat(vertData[vertNum * p + 4]) - minU) / maxUMinusMin;
                            quadUVs[5] = (Float.intBitsToFloat(vertData[vertNum * p + 5]) - minV) / maxVMinusMin;
                            continue;
                        }
                        if (ChisledBlockBaked.isOne(Float.intBitsToFloat(vertData[vertNum * p + a])) && ChisledBlockBaked.isZero(Float.intBitsToFloat(vertData[vertNum * p + b]))) {
                            quadUVs[2] = (Float.intBitsToFloat(vertData[vertNum * p + 4]) - minU) / maxUMinusMin;
                            quadUVs[3] = (Float.intBitsToFloat(vertData[vertNum * p + 5]) - minV) / maxVMinusMin;
                            continue;
                        }
                        quadUVs[6] = (Float.intBitsToFloat(vertData[vertNum * p + 4]) - minU) / maxUMinusMin;
                        quadUVs[7] = (Float.intBitsToFloat(vertData[vertNum * p + 5]) - minV) / maxVMinusMin;
                    }
                }
            }
            sourceUVCache.put(id << 4 | myFace.func_176745_a(), quadUVs);
        }
        return quadUVs;
    }

    private static boolean isOne(float v) {
        return (double)Math.abs(v) < 0.01;
    }

    private static boolean isZero(float v) {
        return (double)Math.abs(v - 1.0f) < 0.01;
    }

    private float[] getFaceUvs(EnumFacing face, Vector3f to_16, Vector3f from_16, float[] quadsUV) {
        float from_a = 0.0f;
        float from_b = 0.0f;
        float to_a = 0.0f;
        float to_b = 0.0f;
        switch (face) {
            case UP: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
            case DOWN: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
            case SOUTH: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.y / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.y / 16.0f;
                break;
            }
            case NORTH: {
                from_a = from_16.x / 16.0f;
                from_b = from_16.y / 16.0f;
                to_a = to_16.x / 16.0f;
                to_b = to_16.y / 16.0f;
                break;
            }
            case EAST: {
                from_a = from_16.y / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.y / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
            case WEST: {
                from_a = from_16.y / 16.0f;
                from_b = from_16.z / 16.0f;
                to_a = to_16.y / 16.0f;
                to_b = to_16.z / 16.0f;
                break;
            }
        }
        float[] afloat = new float[]{16.0f * this.u(quadsUV, from_a, from_b), 16.0f * this.v(quadsUV, from_a, from_b), 16.0f * this.u(quadsUV, to_a, from_b), 16.0f * this.v(quadsUV, to_a, from_b), 16.0f * this.u(quadsUV, to_a, to_b), 16.0f * this.v(quadsUV, to_a, to_b), 16.0f * this.u(quadsUV, from_a, to_b), 16.0f * this.v(quadsUV, from_a, to_b)};
        return afloat;
    }

    float u(float[] src, float U, float V) {
        float u1 = src[0] * U + (1.0f - U) * src[2];
        float u2 = src[4] * U + (1.0f - U) * src[6];
        return u1 * V + (1.0f - V) * u2;
    }

    float v(float[] src, float U, float V) {
        float v1 = src[1] * U + (1.0f - U) * src[3];
        float v2 = src[5] * U + (1.0f - U) * src[7];
        return v1 * V + (1.0f - V) * v2;
    }

    private static Vector3f offsetVec(Vec3i to, EnumFacing f, int d) {
        int left_x = 0;
        boolean left_y = false;
        int left_z = 0;
        boolean up_x = false;
        int up_y = 0;
        int up_z = 0;
        switch (f) {
            case DOWN: {
                left_x = 1;
                up_z = 1;
                break;
            }
            case EAST: {
                left_z = 1;
                up_y = 1;
                break;
            }
            case NORTH: {
                left_x = 1;
                up_y = 1;
                break;
            }
            case SOUTH: {
                left_x = 1;
                up_y = 1;
                break;
            }
            case UP: {
                left_x = 1;
                up_z = 1;
                break;
            }
            case WEST: {
                left_z = 1;
                up_y = 1;
                break;
            }
        }
        int x = to.func_177958_n() + left_x * d + 0 * d;
        int y = to.func_177956_o() + 0 * d + up_y * d;
        int z = to.func_177952_p() + left_z * d + up_z * d;
        return new Vector3f((float)x * 0.5f, (float)y * 0.5f, (float)z * 0.5f);
    }

    public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
        return this.face[p_177551_1_.ordinal()];
    }

    public List<BakedQuad> func_177550_a() {
        return this.generic;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.originalModel == null ? null : this.originalModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public VertexFormat getFormat() {
        return null;
    }
}

