/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import java.util.ArrayList;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.ChiselTypeIterator;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.ChiselInventory;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.network.ModPacket;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ChiselPacket
extends ModPacket {
    BlockPos pos;
    int x;
    int y;
    int z;
    int from_x;
    int from_y;
    int from_z;
    EnumFacing side;
    ChiselMode mode;

    public ChiselPacket() {
    }

    public ChiselPacket(BlockPos pos, int x, int y, int z, int fx, int fy, int fz, EnumFacing side, ChiselMode mode) {
        this.pos = pos;
        this.x = x;
        this.y = y;
        this.z = z;
        this.from_x = fx;
        this.from_y = fy;
        this.from_z = fz;
        this.side = side;
        this.mode = mode;
    }

    public ChiselPacket(BlockPos pos, int x, int y, int z, EnumFacing side, ChiselMode mode) {
        this.pos = pos;
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.mode = mode;
    }

    @Override
    public void server(EntityPlayerMP playerEntity) {
        this.doAction((EntityPlayer)playerEntity);
    }

    public int doAction(EntityPlayer player) {
        TileEntity te;
        World world = player.field_70170_p;
        ChiselInventory chisel = new ChiselInventory(player, this.pos, this.side);
        IBlockState blkstate = world.func_180495_p(this.pos);
        Block blkObj = blkstate.func_177230_c();
        if (!chisel.isValid() || blkObj == null || blkstate == null || !ItemChisel.canMine(chisel, blkstate, player, world, this.pos)) {
            return 0;
        }
        if (BlockChiseled.replaceWithChisled(world, this.pos, blkstate)) {
            blkstate = world.func_180495_p(this.pos);
            blkObj = blkstate.func_177230_c();
        }
        if (blkObj instanceof BlockChiseled && (te = world.func_175625_s(this.pos)) instanceof TileEntityBlockChiseled && chisel.isValid()) {
            TileEntityBlockChiseled tec = (TileEntityBlockChiseled)te;
            VoxelBlob vb = tec.getBlob();
            ItemStack extracted = null;
            ArrayList<EntityItem> spawnlist = new ArrayList<EntityItem>();
            ChiselTypeIterator i = this.getIterator(vb);
            while (i.hasNext() && chisel.isValid()) {
                extracted = ItemChisel.chiselBlock(chisel, player, vb, world, this.pos, i.side, i.x(), i.y(), i.z(), extracted, spawnlist);
            }
            for (EntityItem ei : spawnlist) {
                world.func_72838_d((Entity)ei);
            }
            if (extracted != null) {
                tec.setBlob(vb);
                return ItemChisel.getStackState(extracted);
            }
        }
        return 0;
    }

    private ChiselTypeIterator getIterator(VoxelBlob vb) {
        if (this.mode == ChiselMode.DRAWN_REGION) {
            int lowX = Math.max(0, Math.min(this.x, this.from_x));
            int lowY = Math.max(0, Math.min(this.y, this.from_y));
            int lowZ = Math.max(0, Math.min(this.z, this.from_z));
            int highX = Math.min(16, Math.max(this.x, this.from_x));
            int highY = Math.min(16, Math.max(this.y, this.from_y));
            int highZ = Math.min(16, Math.max(this.z, this.from_z));
            return new ChiselTypeIterator(16, lowX, lowY, lowZ, 1 + highX - lowX, 1 + highY - lowY, 1 + highZ - lowZ, this.side);
        }
        return new ChiselTypeIterator(16, this.x, this.y, this.z, vb, this.mode, this.side);
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        int value = buffer.readInt();
        this.x = value & 0xF;
        this.y = (value >>>= 4) & 0xF;
        this.z = (value >>>= 4) & 0xF;
        value >>>= 4;
        int value2 = buffer.readInt();
        this.from_x = value2 & 0xF;
        this.from_y = (value2 >>>= 4) & 0xF;
        this.from_z = (value2 >>>= 4) & 0xF;
        value2 >>>= 4;
        this.side = EnumFacing.values()[value & 7];
        this.mode = ChiselMode.values()[value >>>= 3];
    }

    @Override
    public void getPayload(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        int value = this.mode.ordinal();
        value <<= 3;
        value |= this.side.ordinal();
        value <<= 4;
        value |= this.z;
        value <<= 4;
        value |= this.y;
        value <<= 4;
        buffer.writeInt(value |= this.x);
        int value2 = 0;
        value2 |= this.from_z;
        value2 <<= 4;
        value2 |= this.from_y;
        value2 <<= 4;
        buffer.writeInt(value2 |= this.from_x);
    }
}

