/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network;

import java.util.HashMap;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.network.packets.BagGuiPacket;
import mod.chiselsandbits.network.packets.ChiselPacket;
import mod.chiselsandbits.network.packets.SetChiselMode;

public enum ModPacketTypes {
    CHISEL(ChiselPacket.class),
    OPEN_BAG_GUI(BagGuiPacket.class),
    SET_CHISEL_MODE(SetChiselMode.class);

    private final Class<? extends ModPacket> packetClass;
    private static HashMap<Class<? extends ModPacket>, Integer> fromClassToId;
    private static HashMap<Integer, Class<? extends ModPacket>> fromIdToClass;

    private ModPacketTypes(Class<? extends ModPacket> clz) {
        this.packetClass = clz;
    }

    public static void init() {
        for (ModPacketTypes p : ModPacketTypes.values()) {
            fromClassToId.put(p.packetClass, p.ordinal());
            fromIdToClass.put(p.ordinal(), p.packetClass);
        }
    }

    public static int getID(Class<? extends ModPacket> clz) {
        return fromClassToId.get(clz);
    }

    public static ModPacket constructByID(int id) throws InstantiationException, IllegalAccessException {
        return fromIdToClass.get(id).newInstance();
    }

    static {
        fromClassToId = new HashMap();
        fromIdToClass = new HashMap();
    }
}

