/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.ChiselInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChisel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemNegativePrint
extends Item {
    public ItemNegativePrint() {
        this.func_77637_a(ChiselsAndBits.creativeTab);
    }

    protected void defaultAddInfo(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        this.defaultAddInfo(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.instance.config.helpText(LocalStrings.HelpNegativePrint, tooltip);
        if (stack.func_77942_o() && !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            tooltip.add(LocalStrings.ShiftDetails.getLocal());
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77942_o()) {
            return super.func_77667_c(stack) + "_written";
        }
        return super.func_77667_c(stack);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState blkstate = world.func_180495_p(pos);
        Block blkObj = blkstate.func_177230_c();
        if (!player.func_175151_a(pos, side, stack)) {
            return true;
        }
        if (!stack.func_77942_o()) {
            NBTTagCompound comp = this.getCompoundFromBlock(world, pos, player);
            if (comp != null) {
                stack.func_77982_d(comp);
                return false;
            }
            return true;
        }
        if (!(blkObj instanceof BlockChiseled) && !BlockChiseled.replaceWithChisled(world, pos, blkstate)) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityBlockChiseled) {
            TileEntityBlockChiseled tec = (TileEntityBlockChiseled)te;
            NBTTagCompound blueprintTag = stack.func_77978_p();
            int rotations = ModUtil.getRotations((EntityLivingBase)player, blueprintTag.func_74771_c("side"));
            VoxelBlob vb = tec.getBlob();
            TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
            tmp.readChisleData(blueprintTag);
            VoxelBlob pattern = tmp.getBlob();
            while (rotations-- > 0) {
                pattern = pattern.spin(EnumFacing.Axis.Y);
            }
            this.applyPrint(world, pos, side, vb, pattern, player);
            tec.setBlob(vb);
            return false;
        }
        return true;
    }

    protected boolean convertToStone() {
        return true;
    }

    protected NBTTagCompound getCompoundFromBlock(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        Block blkObj = world.func_180495_p(pos).func_177230_c();
        if (blkObj instanceof BlockChiseled && (te = world.func_175625_s(pos)) instanceof TileEntityBlockChiseled) {
            NBTTagCompound comp = new NBTTagCompound();
            ((TileEntityBlockChiseled)te).writeChisleData(comp);
            if (this.convertToStone()) {
                TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
                tmp.readChisleData(comp);
                VoxelBlob bestBlob = tmp.getBlob();
                bestBlob.binaryReplacement(0, Block.func_176210_f((IBlockState)Blocks.field_150348_b.func_176223_P()));
                tmp.setBlob(bestBlob);
                tmp.writeChisleData(comp);
            }
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((EntityLivingBase)player).ordinal());
            return comp;
        }
        return null;
    }

    public ItemStack getPatternedItem(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        TileEntityBlockChiseled tebc = new TileEntityBlockChiseled();
        tebc.readChisleData(tag);
        VoxelBlob.CommonBlock common = tebc.getBlob().mostCommonBlock();
        if (common.isFull) {
            IBlockState state = Block.func_176220_d((int)common.ref);
            return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        }
        IBlockState blk = Block.func_176220_d((int)tag.func_74762_e("b"));
        ItemStack itemstack = new ItemStack((Block)ChiselsAndBits.instance.getConversion(blk.func_177230_c().func_149688_o()), 1);
        itemstack.func_77983_a("BlockEntityTag", (NBTBase)tag);
        return itemstack;
    }

    protected void applyPrint(World world, BlockPos pos, EnumFacing side, VoxelBlob vb, VoxelBlob pattern, EntityPlayer player) {
        ChiselInventory selected = new ChiselInventory(player, pos, side);
        ItemStack spawnedItem = null;
        ArrayList<EntityItem> spawnlist = new ArrayList<EntityItem>();
        for (int z = 0; z < vb.detail && selected.isValid(); ++z) {
            for (int y = 0; y < vb.detail && selected.isValid(); ++y) {
                for (int x = 0; x < vb.detail && selected.isValid(); ++x) {
                    int blkID = vb.get(x, y, z);
                    if (blkID == 0 || pattern.get(x, y, z) != 0) continue;
                    spawnedItem = ItemChisel.chiselBlock(selected, player, vb, world, pos, side, x, y, z, spawnedItem, spawnlist);
                }
            }
        }
        for (EntityItem ei : spawnlist) {
            world.func_72838_d((Entity)ei);
        }
    }
}

