/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.ClientSide;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.items.BitColors;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemChiseledBit
extends Item {
    private static final float HALF_16th = 0.03125f;
    private ArrayList<ItemStack> bits;

    public ItemChiseledBit() {
        this.func_77637_a(ChiselsAndBits.creativeTab);
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.instance.config.helpText(LocalStrings.HelpBit, tooltip);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return ItemChisel.fromBreakToChisel(ChiselMode.SINGLE, itemstack, pos, player);
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack target = null;
        try {
            IBlockState state = Block.func_176220_d((int)ItemChisel.getStackState(stack));
            Block blk = state.func_177230_c();
            target = new ItemStack(blk, 1, blk.func_176201_c(state));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (target == null || target.func_77973_b() == null) {
            return super.func_77653_i(stack);
        }
        return super.func_77653_i(stack) + " - " + target.func_82833_r();
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        IBlockState state = Block.func_176220_d((int)ItemChisel.getStackState(stack));
        return BitColors.getColorFor(state, renderPass);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        int z;
        int y;
        int x;
        TileEntityBlockChiseled tec;
        VoxelBlob vb;
        TileEntity te;
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        IBlockState blkstate = world.func_180495_p(pos);
        Block blkObj = blkstate.func_177230_c();
        hitX += (float)side.func_82601_c() * 0.03125f;
        hitY += (float)side.func_96559_d() * 0.03125f;
        hitZ += (float)side.func_82599_e() * 0.03125f;
        if (!(blkObj instanceof BlockChiseled) || (double)hitX < -0.001 || (double)hitY < -0.001 || (double)hitZ < -0.001 || (double)hitX > 1.001 || (double)hitY > 1.001 || (double)hitZ > 1.001) {
            pos = pos.func_177972_a(side);
            hitX -= (float)side.func_82601_c();
            hitY -= (float)side.func_96559_d();
            hitZ -= (float)side.func_82599_e();
            blkstate = world.func_180495_p(pos);
            blkObj = blkstate.func_177230_c();
        }
        if (BlockChiseled.replaceWithChisled(world, pos, blkstate, ItemChisel.getStackState(stack))) {
            blkstate = world.func_180495_p(pos);
            blkObj = blkstate.func_177230_c();
        }
        if (blkObj instanceof BlockChiseled && (te = world.func_175625_s(pos)) instanceof TileEntityBlockChiseled && (vb = (tec = (TileEntityBlockChiseled)te).getBlob()).get(x = Math.min(15, Math.max(0, (int)((float)vb.detail * hitX))), y = Math.min(15, Math.max(0, (int)((float)vb.detail * hitY))), z = Math.min(15, Math.max(0, (int)((float)vb.detail * hitZ)))) == 0) {
            int stateID = ItemChisel.getStackState(stack);
            if (world.field_72995_K) {
                ClientSide.placeSound(world, pos, stateID);
            }
            vb.set(x, y, z, stateID);
            tec.setBlob(vb);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            InventoryPlayer inv = player.field_71071_by;
            for (int zz = 0; zz < inv.func_70302_i_(); ++zz) {
                ItemStack which = inv.func_70301_a(zz);
                if (which == null || !(which.func_77973_b() instanceof ItemBitBag)) continue;
                new BagInventory(which).restockItem(stack);
            }
            return false;
        }
        return true;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List subItems) {
        if (this.bits == null) {
            this.bits = new ArrayList();
            ArrayList List2 = new ArrayList();
            for (Object obj : Item.field_150901_e) {
                if (!(obj instanceof ItemBlock)) continue;
                try {
                    Item it = (Item)obj;
                    it.func_150895_a(it, it.func_77640_w(), List2);
                    for (ItemStack out : List2) {
                        it = out.func_77973_b();
                        if (!(it instanceof ItemBlock)) continue;
                        ItemBlock ib = (ItemBlock)it;
                        IBlockState state = ib.field_150939_a.func_176203_a(out.func_77960_j());
                        if (state == null || !BlockChiseled.supportsBlock(state)) continue;
                        this.bits.add(ItemChiseledBit.createStack(Block.func_176210_f((IBlockState)state), 1, false));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                List2.clear();
            }
        }
        subItems.addAll(this.bits);
    }

    public static boolean sameBit(ItemStack output, int blk) {
        return output.func_77942_o() ? output.func_77978_p().func_74762_e("id") == blk : false;
    }

    public static ItemStack createStack(int id, int count, boolean RequireStack) {
        if (ChiselsAndBits.instance.itemBlockBit == null && !RequireStack) {
            return null;
        }
        ItemStack out = new ItemStack((Item)ChiselsAndBits.instance.itemBlockBit, count);
        out.func_77983_a("id", (NBTBase)new NBTTagInt(id));
        return out;
    }
}

