/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import com.google.common.base.Stopwatch;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.ClientSide;
import mod.chiselsandbits.ReflectionWrapper;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.ChiselInventory;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.ChiselPacket;
import mod.chiselsandbits.network.packets.SetChiselMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemChisel
extends ItemTool {
    private static final float one_16th = 0.0625f;
    private static ChiselMode clientChiselMode = ChiselMode.SINGLE;
    private static Stopwatch timer;
    private static final float One32ndf = 0.03125f;
    private static boolean testingChisel;

    public ItemChisel(Item.ToolMaterial material) {
        super(0.1f, material, new HashSet());
        this.func_77637_a(ChiselsAndBits.creativeTab);
        long uses = (long)material.func_77997_a() * ChiselsAndBits.instance.config.availableUsesMultiplier;
        this.func_77656_e(ChiselsAndBits.instance.config.damageTools ? (int)Math.max(0L, Math.min(32767L, uses)) : 0);
    }

    public Item.ToolMaterial whatMaterial() {
        return this.field_77862_b;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.instance.config.helpText(LocalStrings.HelpChisel, tooltip);
    }

    public static void resetDelay() {
        timer = null;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return ItemChisel.fromBreakToChisel(ItemChisel.getChiselMode(), itemstack, pos, player);
    }

    public static boolean fromBreakToChisel(ChiselMode mode, ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (itemstack != null && (timer == null || timer.elapsed(TimeUnit.MILLISECONDS) > 100L)) {
            timer = Stopwatch.createStarted();
            if (mode == ChiselMode.DRAWN_REGION) {
                Pair<Vec3, Vec3> PlayerRay = ModUtil.getPlayerRay(player);
                Vec3 a = (Vec3)PlayerRay.getLeft();
                Vec3 b = (Vec3)PlayerRay.getRight();
                MovingObjectPosition mop = player.field_70170_p.func_180495_p(pos).func_177230_c().func_180636_a(player.field_70170_p, pos, a, b);
                if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    int x = ItemChisel.getX((float)mop.field_72307_f.field_72450_a - (float)pos.func_177958_n(), mop.field_178784_b);
                    int y = ItemChisel.getY((float)mop.field_72307_f.field_72448_b - (float)pos.func_177956_o(), mop.field_178784_b);
                    int z = ItemChisel.getZ((float)mop.field_72307_f.field_72449_c - (float)pos.func_177952_p(), mop.field_178784_b);
                    ClientSide.instance.pointAt(pos, x, y, z);
                    return true;
                }
                return true;
            }
            if (!player.field_70170_p.field_72995_K) {
                return true;
            }
            Pair<Vec3, Vec3> PlayerRay = ModUtil.getPlayerRay(player);
            Vec3 a = (Vec3)PlayerRay.getLeft();
            Vec3 b = (Vec3)PlayerRay.getRight();
            MovingObjectPosition mop = player.field_70170_p.func_180495_p(pos).func_177230_c().func_180636_a(player.field_70170_p, pos, a, b);
            if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ItemChisel.useChisel(mode, player, player.field_70170_p, pos, mop.field_178784_b, (float)(mop.field_72307_f.field_72450_a - (double)pos.func_177958_n()), (float)(mop.field_72307_f.field_72448_b - (double)pos.func_177956_o()), (float)(mop.field_72307_f.field_72449_c - (double)pos.func_177952_p()));
            }
        }
        return true;
    }

    public static void scrollOption(ChiselMode originalMode, ChiselMode currentMode, int dwheel) {
        int offset = currentMode.ordinal() + (dwheel < 0 ? -1 : 1);
        if (offset >= ChiselMode.values().length) {
            offset = 0;
        }
        if (offset < 0) {
            offset = ChiselMode.values().length - 1;
        }
        currentMode = ChiselMode.values()[offset];
        if (currentMode.isDisabled) {
            ItemChisel.scrollOption(originalMode, currentMode, dwheel);
        } else {
            ItemChisel.changeChiselMode(originalMode, currentMode);
        }
    }

    public static ChiselMode getChiselMode() {
        ItemStack ei;
        if (ChiselsAndBits.instance.config.perChiselMode && (ei = Minecraft.func_71410_x().field_71439_g.func_71045_bC()) != null && ei.func_77973_b() instanceof ItemChisel) {
            return ChiselMode.getMode(ei);
        }
        return clientChiselMode;
    }

    public String func_77653_i(ItemStack stack) {
        return this.getHighlightTip(stack, super.func_77653_i(stack));
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        if (ChiselsAndBits.instance.config.itemNameModeDisplay) {
            if (ChiselsAndBits.instance.config.perChiselMode) {
                return displayName + " - " + ChiselMode.getMode((ItemStack)item).string.getLocal();
            }
            return displayName + " - " + ItemChisel.getChiselMode().string.getLocal();
        }
        return displayName;
    }

    public static void changeChiselMode(ChiselMode originalMode, ChiselMode newClientChiselMode) {
        boolean chatNotification = ChiselsAndBits.instance.config.chatModeNotification;
        boolean itemNameModeDisplay = ChiselsAndBits.instance.config.itemNameModeDisplay;
        if (ChiselsAndBits.instance.config.perChiselMode) {
            SetChiselMode packet = new SetChiselMode();
            packet.mode = newClientChiselMode;
            packet.chatNotification = chatNotification;
            if (!itemNameModeDisplay) {
                newClientChiselMode.setMode(Minecraft.func_71410_x().field_71439_g.func_71045_bC());
            }
            NetworkRouter.instance.sendToServer(packet);
        } else {
            clientChiselMode = newClientChiselMode;
            if (originalMode != clientChiselMode && chatNotification) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)new ChatComponentTranslation(ItemChisel.clientChiselMode.string.toString(), new Object[0]));
            }
            ReflectionWrapper.instance.clearHighlightedStack();
        }
        if (!itemNameModeDisplay) {
            ReflectionWrapper.instance.endHighlightedStack();
        }
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            ChiselMode mode = ItemChisel.getChiselMode();
            ItemChisel.scrollOption(mode, mode, playerIn.func_70093_af() ? -1 : 1);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            this.func_77659_a(stack, world, player);
        }
        return true;
    }

    private static int getX(float hitX, EnumFacing side) {
        return Math.min(15, Math.max(0, (int)(16.0f * (hitX - 0.03125f * (float)side.func_82601_c()))));
    }

    private static int getY(float hitY, EnumFacing side) {
        return Math.min(15, Math.max(0, (int)(16.0f * (hitY - 0.03125f * (float)side.func_96559_d()))));
    }

    private static int getZ(float hitZ, EnumFacing side) {
        return Math.min(15, Math.max(0, (int)(16.0f * (hitZ - 0.03125f * (float)side.func_82599_e()))));
    }

    static void useChisel(ChiselMode mode, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        int z;
        int y;
        int x = ItemChisel.getX(hitX, side);
        ChiselPacket pc = new ChiselPacket(pos, x, y = ItemChisel.getY(hitY, side), z = ItemChisel.getZ(hitZ, side), side, mode);
        int extractedState = pc.doAction(player);
        if (extractedState != 0) {
            ClientSide.breakSound(world, pos, extractedState);
            NetworkRouter.instance.sendToServer(pc);
        }
    }

    public static ItemStack chiselBlock(ChiselInventory selected, EntityPlayer player, VoxelBlob vb, World world, BlockPos pos, EnumFacing side, int x, int y, int z, ItemStack output, List<EntityItem> spawnlist) {
        boolean spawnBit;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        int blk = vb.get(x, y, z);
        if (blk == 0) {
            return output;
        }
        if (!ItemChisel.canMine(selected, Block.func_176220_d((int)blk), player, world, pos)) {
            return output;
        }
        selected.damage(blk);
        boolean bl = spawnBit = ChiselsAndBits.instance.itemBlockBit != null;
        if (!world.field_72995_K && !isCreative) {
            double hitX = (float)x * 0.0625f;
            double hitY = (float)y * 0.0625f;
            double hitZ = (float)z * 0.0625f;
            double offset = 0.5;
            hitX += (double)side.func_82601_c() * 0.5;
            hitY += (double)side.func_96559_d() * 0.5;
            hitZ += (double)side.func_82599_e() * 0.5;
            if (output == null || !ItemChiseledBit.sameBit(output, blk) || output.field_77994_a == 64) {
                output = ItemChiseledBit.createStack(blk, 1, true);
                if (spawnBit) {
                    spawnlist.add(new EntityItem(world, (double)pos.func_177958_n() + hitX, (double)pos.func_177956_o() + hitY, (double)pos.func_177952_p() + hitZ, output));
                }
            } else {
                ++output.field_77994_a;
            }
        } else {
            output = ItemChiseledBit.createStack(blk, 1, true);
        }
        vb.clear(x, y, z);
        return output;
    }

    public static int getStackState(ItemStack inHand) {
        return inHand != null && inHand.func_77942_o() ? inHand.func_77978_p().func_74762_e("id") : 0;
    }

    public static boolean canMine(ChiselInventory chiselInv, IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        int targetState = Block.func_176210_f((IBlockState)state);
        ModUtil.ItemStackSlot chiselSlot = chiselInv.getTool(targetState);
        ItemStack chisel = chiselSlot.getStack();
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (chisel == null) {
            return false;
        }
        if (ChiselsAndBits.instance.config.enableChiselToolHarvestCheck) {
            if (state.func_177230_c() instanceof BlockChiseled) {
                return true;
            }
            do {
                Block blk = world.func_180495_p(pos).func_177230_c();
                BlockChiseled.actingAs = state;
                testingChisel = true;
                chiselSlot.swapWithWeapon();
                boolean canHarvest = blk.canHarvestBlock((IBlockAccess)world, pos, player);
                chiselSlot.swapWithWeapon();
                testingChisel = false;
                BlockChiseled.actingAs = null;
                if (canHarvest) {
                    return true;
                }
                chiselInv.fail(targetState);
            } while ((chisel = (chiselSlot = chiselInv.getTool(targetState)).getStack()) != null);
            return false;
        }
        return true;
    }

    public boolean func_150897_b(Block blk) {
        Item it;
        switch (this.func_150913_i()) {
            case EMERALD: {
                it = Items.field_151046_w;
                break;
            }
            case GOLD: {
                it = Items.field_151005_D;
                break;
            }
            case IRON: {
                it = Items.field_151035_b;
                break;
            }
            default: {
                it = Items.field_151050_s;
                break;
            }
            case WOOD: {
                it = Items.field_151039_o;
            }
        }
        return blk instanceof BlockChiseled || it.func_150897_b(blk);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        String pattern;
        Pattern p;
        Matcher m;
        if (testingChisel && stack.func_77973_b() instanceof ItemChisel && (m = (p = Pattern.compile(pattern = "(^|,)" + Pattern.quote(toolClass) + "(,|$)")).matcher(ChiselsAndBits.instance.config.enableChiselToolHarvestCheckTools)).find()) {
            ItemChisel ic = (ItemChisel)stack.func_77973_b();
            return ic.field_77862_b.func_77996_d();
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    static {
        testingChisel = false;
    }
}

