/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import mod.chiselsandbits.ChiselMode;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.items.ItemPositivePrint;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;

public class ModUtil {
    public static EnumFacing getPlaceFace(EntityLivingBase placer) {
        return EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
    }

    public static Pair<Vec3, Vec3> getPlayerRay(EntityPlayer playerIn) {
        double reachDistance = 5.0;
        double x = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q);
        double y = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double z = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s);
        float playerPitch = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float playerYaw = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        float yawRayX = MathHelper.func_76126_a((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = MathHelper.func_76134_b((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -MathHelper.func_76134_b((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = MathHelper.func_76126_a((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        if (playerIn instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3 from = new Vec3(x, y, z);
        Vec3 to = from.func_72441_c((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return Pair.of((Object)from, (Object)to);
    }

    public static ItemStackSlot findBit(EntityPlayer who, int StateID) {
        ItemStack inHand = who.func_71045_bC();
        if (inHand != null && inHand.field_77994_a > 0 && inHand.func_77973_b() instanceof ItemChiseledBit && ItemChisel.getStackState(inHand) == StateID) {
            return new ItemStackSlot((IInventory)who.field_71071_by, who.field_71071_by.field_70461_c, inHand, who);
        }
        for (int x = 0; x < who.field_71071_by.func_70302_i_(); ++x) {
            ItemStack is = who.field_71071_by.func_70301_a(x);
            if (is == null || is.field_77994_a <= 0 || !(is.func_77973_b() instanceof ItemChiseledBit) || !ItemChiseledBit.sameBit(is, StateID)) continue;
            return new ItemStackSlot((IInventory)who.field_71071_by, x, is, who);
        }
        return new ItemStackSlot(null, -1, null, who);
    }

    public static ChiselMode isHoldingChiselTool(EntityPlayer player) {
        ItemStack inHand = player.func_71045_bC();
        if (inHand != null && inHand.func_77973_b() instanceof ItemChiseledBit) {
            return ChiselMode.SINGLE;
        }
        if (inHand != null && inHand.func_77973_b() instanceof ItemChisel) {
            return ItemChisel.getChiselMode();
        }
        return null;
    }

    public static boolean isHoldingPattern(EntityPlayer player) {
        ItemStack inHand = player.func_71045_bC();
        if (inHand != null && inHand.func_77973_b() instanceof ItemPositivePrint) {
            return true;
        }
        return inHand != null && inHand.func_77973_b() instanceof ItemNegativePrint;
    }

    public static boolean isHoldingChiseledBlock(EntityPlayer player) {
        ItemStack inHand = player.func_71045_bC();
        return inHand != null && inHand.func_77973_b() instanceof ItemBlockChiseled;
    }

    public static int getRotationIndex(EnumFacing face) {
        return face.func_176736_b();
    }

    public static int getRotations(EntityLivingBase placer, byte side) {
        int rotations;
        EnumFacing newFace = ModUtil.getPlaceFace(placer);
        EnumFacing oldYaw = EnumFacing.field_82609_l[side];
        for (rotations = ModUtil.getRotationIndex(newFace) - ModUtil.getRotationIndex(oldYaw); rotations < 0; rotations = 4 + rotations) {
        }
        while (rotations > 4) {
            rotations -= 4;
        }
        return 4 - rotations;
    }

    public static BlockPos getPartialOffset(EnumFacing side, BlockPos partial, IntegerBox modelBounds) {
        int offset_x = modelBounds.minX;
        int offset_y = modelBounds.minY;
        int offset_z = modelBounds.minZ;
        int partial_x = partial.func_177958_n();
        int partial_y = partial.func_177956_o();
        int partial_z = partial.func_177952_p();
        int middle_x = (modelBounds.maxX - modelBounds.minX) / -2;
        int middle_y = (modelBounds.maxY - modelBounds.minY) / -2;
        int middle_z = (modelBounds.maxZ - modelBounds.minZ) / -2;
        switch (side) {
            case DOWN: {
                offset_y = modelBounds.maxY;
                middle_y = 0;
                break;
            }
            case EAST: {
                offset_x = modelBounds.minX;
                middle_x = 0;
                break;
            }
            case NORTH: {
                offset_z = modelBounds.maxZ;
                middle_z = 0;
                break;
            }
            case SOUTH: {
                offset_z = modelBounds.minZ;
                middle_z = 0;
                break;
            }
            case UP: {
                offset_y = modelBounds.minY;
                middle_y = 0;
                break;
            }
            case WEST: {
                offset_x = modelBounds.maxX;
                middle_x = 0;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        int t_x = -offset_x + middle_x + partial_x;
        int t_y = -offset_y + middle_y + partial_y;
        int t_z = -offset_z + middle_z + partial_z;
        return new BlockPos(t_x, t_y, t_z);
    }

    public static class ItemStackSlot {
        private final IInventory inv;
        private final int slot;
        private final ItemStack stack;
        private final boolean isCreative;
        private final int toolSlot;

        ItemStackSlot(IInventory i, int s, ItemStack st, EntityPlayer player) {
            this.inv = i;
            this.slot = s;
            this.stack = st;
            this.toolSlot = player.field_71071_by.field_70461_c;
            this.isCreative = player.field_71075_bZ.field_75098_d;
        }

        public boolean isValid() {
            return this.isCreative || this.stack != null && this.stack.field_77994_a > 0;
        }

        public void damage(EntityPlayer who) {
            if (this.isCreative) {
                return;
            }
            this.stack.func_77972_a(1, (EntityLivingBase)who);
            if (this.stack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)who, (ItemStack)this.stack);
                this.inv.func_70299_a(this.slot, null);
            }
        }

        public void consume() {
            if (this.isCreative) {
                return;
            }
            --this.stack.field_77994_a;
            if (this.stack.field_77994_a <= 0) {
                this.inv.func_70299_a(this.slot, null);
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void swapWithWeapon() {
            ItemStack it = this.inv.func_70301_a(this.toolSlot);
            this.inv.func_70299_a(this.toolSlot, this.inv.func_70301_a(this.slot));
            this.inv.func_70299_a(this.slot, it);
        }
    }
}

