/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChisel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

public class ChiselInventory {
    private final EntityPlayer who;
    private final List<ModUtil.ItemStackSlot> options = new ArrayList<ModUtil.ItemStackSlot>();
    private final HashMap<Integer, List<ModUtil.ItemStackSlot>> actionCache = new HashMap();

    public ChiselInventory(EntityPlayer who, BlockPos pos, EnumFacing side) {
        this.who = who;
        ItemStack inHand = who.func_71045_bC();
        if (inHand != null && inHand.field_77994_a > 0 && inHand.func_77973_b() instanceof ItemChisel) {
            if (who.func_175151_a(pos, side, inHand)) {
                this.options.add(new ModUtil.ItemStackSlot((IInventory)who.field_71071_by, who.field_71071_by.field_70461_c, inHand, who));
            }
        } else {
            ArrayListMultimap discovered = ArrayListMultimap.create();
            for (int x = 0; x < who.field_71071_by.func_70302_i_(); ++x) {
                ItemStack is = who.field_71071_by.func_70301_a(x);
                if (is == inHand || !who.func_175151_a(pos, side, is) || is == null || is.field_77994_a <= 0 || !(is.func_77973_b() instanceof ItemChisel)) continue;
                Item.ToolMaterial newMat = ((ItemChisel)is.func_77973_b()).whatMaterial();
                discovered.put((Object)newMat.func_77996_d(), (Object)new ModUtil.ItemStackSlot((IInventory)who.field_71071_by, x, is, who));
            }
            ArrayList allValues = Lists.newArrayList((Iterable)discovered.values());
            for (ModUtil.ItemStackSlot f : Lists.reverse((List)allValues)) {
                this.options.add(f);
            }
        }
    }

    public ModUtil.ItemStackSlot getTool(int BlockID) {
        List<ModUtil.ItemStackSlot> choices;
        if (!this.actionCache.containsKey(BlockID)) {
            this.actionCache.put(BlockID, new ArrayList<ModUtil.ItemStackSlot>(this.options));
        }
        if ((choices = this.actionCache.get(BlockID)).isEmpty()) {
            return new ModUtil.ItemStackSlot(null, -1, null, this.who);
        }
        ModUtil.ItemStackSlot slot = choices.get(choices.size() - 1);
        if (slot.isValid()) {
            return slot;
        }
        this.fail(BlockID);
        return this.getTool(BlockID);
    }

    public void fail(int BlockID) {
        List<ModUtil.ItemStackSlot> choices = this.actionCache.get(BlockID);
        if (!choices.isEmpty()) {
            choices.remove(choices.size() - 1);
        }
    }

    public boolean isValid() {
        return !this.options.isEmpty() || this.who.field_71075_bZ.field_75098_d;
    }

    public void damage(int blk) {
        this.getTool(blk).damage(this.who);
    }
}

